/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.message;

import org.apache.geronimo.gshell.command.CommandExecutor;
import org.apache.geronimo.gshell.remote.message.RshMessage;

public class ExecuteMessage
extends RshMessage {
    private final Flavor flavor;
    private final String path;
    private final Object[] args;
    private final Object[][] cmds;

    private ExecuteMessage(Flavor flavor, String path, Object[] args, Object[][] cmds) {
        this.flavor = flavor;
        this.path = path;
        this.args = args;
        this.cmds = cmds;
    }

    public ExecuteMessage(String commandLine) {
        this(Flavor.STRING, null, new Object[]{commandLine}, null);
    }

    public ExecuteMessage(Object[] args) {
        this(Flavor.OBJECTS, null, args, null);
    }

    public ExecuteMessage(String path, Object[] args) {
        this(Flavor.STRING_OBJECTS, path, args, null);
    }

    public ExecuteMessage(Object[][] cmds) {
        this(Flavor.COMMANDS, null, null, cmds);
    }

    public ExecuteMessage() {
        this(null, null, null, null);
    }

    public Object execute(CommandExecutor executor) throws Exception {
        assert (executor != null);
        return this.flavor.execute(this, executor);
    }

    public static class Notification
    extends Result {
        public Notification(org.apache.geronimo.gshell.common.Notification n) {
            super(n);
        }

        public org.apache.geronimo.gshell.common.Notification getNotification() {
            return (org.apache.geronimo.gshell.common.Notification)this.getResult();
        }
    }

    public static class Fault
    extends Result {
        public Fault(Throwable cause) {
            super(cause);
        }

        public Throwable getCause() {
            return (Throwable)this.getResult();
        }
    }

    public static class Result
    extends RshMessage {
        private final Object result;

        public Result(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Flavor
    extends Enum<Flavor> {
        public static final /* enum */ Flavor STRING = new Flavor();
        public static final /* enum */ Flavor OBJECTS = new Flavor();
        public static final /* enum */ Flavor STRING_OBJECTS = new Flavor();
        public static final /* enum */ Flavor COMMANDS = new Flavor();
        private static final /* synthetic */ Flavor[] $VALUES;

        public static final Flavor[] values() {
            return (Flavor[])$VALUES.clone();
        }

        public static Flavor valueOf(String name) {
            return Enum.valueOf(Flavor.class, name);
        }

        public Object execute(ExecuteMessage msg, CommandExecutor executor) throws Exception {
            assert (msg != null);
            assert (executor != null);
            switch (this) {
                case STRING: {
                    return executor.execute((String)msg.args[0]);
                }
                case OBJECTS: {
                    return executor.execute(msg.args);
                }
                case STRING_OBJECTS: {
                    return executor.execute(msg.path, msg.args);
                }
                case COMMANDS: {
                    return executor.execute(msg.cmds);
                }
            }
            throw new Error();
        }

        static {
            $VALUES = new Flavor[]{STRING, OBJECTS, STRING_OBJECTS, COMMANDS};
        }
    }
}

