/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.server;

import org.apache.geronimo.gshell.command.CommandExecutor;
import org.apache.geronimo.gshell.remote.RemoteShell;
import org.apache.geronimo.gshell.shell.Environment;
import org.apache.geronimo.gshell.shell.ShellInfo;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=RemoteShell.class, instantiationStrategy="per-lookup")
public class DefaultRemoteShell
implements RemoteShell {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private ShellInfo shellInfo;
    @Requirement
    private CommandExecutor executor;
    @Requirement
    private Environment env;
    private boolean opened = true;

    public DefaultRemoteShell() {
    }

    public DefaultRemoteShell(ShellInfo shellInfo, CommandExecutor executor, Environment env) {
        this.shellInfo = shellInfo;
        this.executor = executor;
        this.env = env;
    }

    private void ensureOpened() {
        if (!this.opened) {
            throw new IllegalStateException("Not opened");
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void close() {
        this.log.debug("Closing");
        this.opened = false;
    }

    public Environment getEnvironment() {
        this.ensureOpened();
        return this.env;
    }

    public ShellInfo getShellInfo() {
        this.ensureOpened();
        return this.shellInfo;
    }

    public Object execute(String line) throws Exception {
        this.ensureOpened();
        return this.executor.execute(line);
    }

    public Object execute(Object ... args) throws Exception {
        this.ensureOpened();
        return this.executor.execute(args);
    }

    public Object execute(String path, Object[] args) throws Exception {
        this.ensureOpened();
        return this.executor.execute(path, args);
    }

    public Object execute(Object[][] commands) throws Exception {
        this.ensureOpened();
        return this.executor.execute(commands);
    }
}

