/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.server.handler;

import org.apache.geronimo.gshell.remote.crypto.CryptoContext;
import org.apache.geronimo.gshell.remote.message.ConnectMessage;
import org.apache.geronimo.gshell.remote.server.RshServer;
import org.apache.geronimo.gshell.remote.server.handler.ServerMessageHandler;
import org.apache.geronimo.gshell.remote.server.handler.ServerMessageHandlerSupport;
import org.apache.geronimo.gshell.remote.server.handler.ServerSessionContext;
import org.apache.geronimo.gshell.remote.server.timeout.TimeoutManager;
import org.apache.geronimo.gshell.whisper.transport.Session;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ServerMessageHandler.class, hint="connect")
public class ConnectHandler
extends ServerMessageHandlerSupport<ConnectMessage> {
    @Requirement
    private CryptoContext crypto;
    @Requirement
    private TimeoutManager timeoutManager;

    public ConnectHandler() {
        super(ConnectMessage.class);
    }

    public ConnectHandler(CryptoContext crypto, TimeoutManager timeoutManager) {
        this();
        this.crypto = crypto;
        this.timeoutManager = timeoutManager;
    }

    @Override
    public void handle(final Session session, ServerSessionContext context, ConnectMessage message) throws Exception {
        if (!this.timeoutManager.cancelTimeout(session)) {
            this.log.warn("Aborting handshake processing; timeout has triggered");
        } else {
            context.pk = message.getPublicKey();
            ConnectMessage.Result reply = new ConnectMessage.Result(this.crypto.getPublicKey());
            reply.setCorrelationId(message.getId());
            session.send(reply);
            this.timeoutManager.scheduleTimeout(session, RshServer.AUTH_TIMEOUT, new Runnable(){

                public void run() {
                    ConnectHandler.this.log.error("Timeout waiting for login from: {}", (Object)session);
                    session.close();
                }
            });
        }
    }
}

