/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.server.timeout;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.geronimo.gshell.common.Duration;
import org.apache.geronimo.gshell.common.NamedThreadFactory;
import org.apache.geronimo.gshell.remote.server.timeout.TimeoutManager;
import org.apache.geronimo.gshell.whisper.transport.Session;
import org.apache.geronimo.gshell.whisper.util.SessionAttributeBinder;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=TimeoutManager.class)
public class DefaultTimeoutManager
implements TimeoutManager,
Initializable {
    private static final SessionAttributeBinder<ScheduledFuture> TIMEOUT = new SessionAttributeBinder(TimeoutManager.class, "timeout");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ScheduledThreadPoolExecutor scheduler;

    public void initialize() throws InitializationException {
        NamedThreadFactory tf = new NamedThreadFactory(this.getClass());
        this.scheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), tf);
    }

    public ScheduledFuture scheduleTimeout(Session session, Duration timeout, Runnable task) {
        assert (session != null);
        assert (timeout != null);
        assert (task != null);
        ScheduledFuture<?> tf = this.scheduler.schedule(task, timeout.value, timeout.unit);
        TIMEOUT.rebind(session.getSession(), tf);
        return tf;
    }

    public boolean cancelTimeout(Session session) {
        assert (session != null);
        ScheduledFuture tf = TIMEOUT.lookup(session.getSession());
        return tf.cancel(false);
    }
}

