/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.layout.LayoutManager;
import org.apache.geronimo.gshell.layout.NotFoundException;
import org.apache.geronimo.gshell.layout.model.CommandNode;
import org.apache.geronimo.gshell.layout.model.GroupNode;
import org.apache.geronimo.gshell.layout.model.Layout;
import org.apache.geronimo.gshell.layout.model.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiLayoutManager
implements LayoutManager {
    private final HashMap<String, Layout> layouts = new HashMap();
    private String shell = "";

    public void register(Command command, Map<String, ?> properties) {
        String shellName = (String)properties.get("shell");
        if (shellName != null) {
            Layout layout = this.getLayoutForShell(shellName);
            String id = command.getId();
            String alias = (String)properties.get("alias");
            if (alias == null) {
                alias = id;
                int p = alias.lastIndexOf(":");
                if (p >= 0) {
                    alias = alias.substring(p + 1);
                }
                layout.add(new CommandNode(alias, id));
            } else {
                String[] aliases;
                for (String a : aliases = alias.split(",")) {
                    if ((a = a.trim()).length() <= 0) continue;
                    layout.add(new CommandNode(a, id));
                }
            }
        }
    }

    public void unregister(Command command, Map<String, ?> properties) {
    }

    @Override
    public Node findNode(String path) throws NotFoundException {
        return this.findNode(this.getLayout(), path);
    }

    @Override
    public Node findNode(Node start, String path) throws NotFoundException {
        assert (start != null);
        assert (path != null);
        if (!(start instanceof GroupNode)) {
            throw new NotFoundException(path);
        }
        Node node = ((GroupNode)start).find(path);
        if (node == null) {
            throw new NotFoundException(path);
        }
        return node;
    }

    @Override
    public Node findNode(String path, String searchPath) throws NotFoundException {
        return this.findNode(path);
    }

    @Override
    public Layout getLayout() {
        return this.getLayoutForShell(this.shell);
    }

    public Layout getLayoutForShell(String shellName) {
        Layout layout = this.layouts.get(shellName);
        if (layout == null) {
            layout = new Layout();
            this.layouts.put(shellName, layout);
        }
        return layout;
    }

    public String getShell() {
        return this.shell;
    }

    public void setShell(String shell) {
        this.shell = shell;
    }

    public LayoutManager createLayoutManagerForShell(final String shell) {
        return new LayoutManager(){

            public Node findNode(String path) throws NotFoundException {
                return OsgiLayoutManager.this.findNode(OsgiLayoutManager.this.getLayoutForShell(shell), path);
            }

            public Node findNode(Node node, String path) throws NotFoundException {
                return OsgiLayoutManager.this.findNode(node, path);
            }

            public Node findNode(String path, String searchPath) throws NotFoundException {
                return OsgiLayoutManager.this.findNode(path, searchPath);
            }

            public Layout getLayout() {
                return OsgiLayoutManager.this.getLayoutForShell(shell);
            }
        };
    }
}

