/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import org.apache.geronimo.gshell.ansi.Renderer;
import org.apache.geronimo.gshell.branding.Branding;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandSupport;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.layout.LayoutManager;
import org.apache.geronimo.gshell.layout.model.AliasNode;
import org.apache.geronimo.gshell.layout.model.CommandNode;
import org.apache.geronimo.gshell.layout.model.GroupNode;
import org.apache.geronimo.gshell.layout.model.Layout;
import org.apache.geronimo.gshell.layout.model.Node;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.registry.NotRegisteredException;
import org.apache.geronimo.gshell.spring.ShellContext;
import org.codehaus.plexus.util.StringUtils;

@CommandComponent(id="osgi-builtins:help", description="Show command help")
public class SubShellHelpCommand
extends CommandSupport {
    @Argument(metaVar="COMMAND", description="Display help for COMMAND")
    private String command;
    private Renderer renderer = new Renderer();

    protected Object doExecute() throws Exception {
        this.io.out.println();
        if (this.command == null) {
            this.displayAvailableCommands();
        } else {
            this.displayCommandHelp(this.command);
        }
        return SUCCESS;
    }

    private void displayAvailableCommands() throws Exception {
        LayoutManager layoutManager = this.getLayoutManager();
        Branding branding = this.getBranding();
        this.io.out.print(branding.getAbout());
        this.io.out.println();
        this.io.out.println("Available commands:");
        Layout group = layoutManager.getLayout();
        this.displayGroupCommands(group);
    }

    private Branding getBranding() {
        return ShellContext.get().getBranding();
    }

    private LayoutManager getLayoutManager() {
        return ShellContext.get().getLayoutManager();
    }

    private CommandRegistry getCommandRegistry() {
        return ShellContext.get().getCommandRegistry();
    }

    private void displayGroupCommands(GroupNode group) throws Exception {
        Node node;
        CommandRegistry commandRegistry = this.getCommandRegistry();
        int maxNameLen = 20;
        for (Node child : group.nodes()) {
            String name;
            if (child instanceof CommandNode) {
                try {
                    node = (CommandNode)child;
                    name = StringUtils.rightPad(node.getName(), maxNameLen);
                    Command command = commandRegistry.lookup(((CommandNode)node).getId());
                    String desc = command.getDescription();
                    this.io.out.print("  ");
                    this.io.out.print(this.renderer.render(Renderer.encode(name, 1)));
                    if (desc != null) {
                        this.io.out.print("  ");
                        this.io.out.println(desc);
                        continue;
                    }
                    this.io.out.println();
                }
                catch (NotRegisteredException e) {}
                continue;
            }
            if (!(child instanceof AliasNode)) continue;
            node = (AliasNode)child;
            name = StringUtils.rightPad(node.getName(), maxNameLen);
            this.io.out.print("  ");
            this.io.out.print(this.renderer.render(Renderer.encode(name, 1)));
            this.io.out.print("  ");
            this.io.out.print("Alias to: ");
            this.io.out.println(this.renderer.render(Renderer.encode(((AliasNode)node).getCommand(), 1)));
        }
        this.io.out.println();
        for (Node child : group.nodes()) {
            if (!(child instanceof GroupNode)) continue;
            node = (GroupNode)child;
            this.io.out.print("  ");
            this.io.out.println(this.renderer.render(Renderer.encode(node.getPath(), 1)));
            this.io.out.println();
            this.displayGroupCommands((GroupNode)node);
            this.io.out.println();
        }
    }

    private void displayCommandHelp(String path) throws Exception {
        assert (path != null);
        CommandRegistry commandRegistry = this.getCommandRegistry();
        Command cmd = commandRegistry.lookup(path);
        if (cmd == null) {
            this.io.out.println("Command " + Renderer.encode(path, 1) + " not found.");
            this.io.out.println("Try " + Renderer.encode("help", 1) + " for a list of available commands.");
        } else {
            this.io.out.println("Command " + Renderer.encode(path, 1));
            this.io.out.println("   " + cmd.getDescription());
        }
        this.io.out.println();
    }
}

