/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.gshell.clp.CommandLineProcessor;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.clp.Printer;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.command.IO;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.common.Arguments;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.BundleContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsgiCommandSupport
implements Command,
BundleContextAware {
    private BundleContext bundleContext;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected CommandContext context;
    protected IO io;
    protected Variables variables;
    protected List<ServiceReference> usedReferences;
    @Option(name="-h", aliases={"--help"}, description="Display this help message", requireOverride=true)
    private boolean displayHelp;

    @Override
    public String getId() {
        CommandComponent cmd = this.getClass().getAnnotation(CommandComponent.class);
        if (cmd == null) {
            throw new IllegalStateException("Command id not found");
        }
        return cmd.id();
    }

    @Override
    public String getDescription() {
        CommandComponent cmd = this.getClass().getAnnotation(CommandComponent.class);
        if (cmd == null) {
            throw new IllegalStateException("Command description not found");
        }
        return cmd.description();
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public Object execute(CommandContext context, Object ... args) throws Exception {
        ClassLoader cl = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        OsgiCommandSupport cmd = this.createCommand();
        cmd.setBundleContext(this.bundleContext);
        cmd.init(context);
        return cmd.doExecute(args);
    }

    protected OsgiCommandSupport createCommand() throws Exception {
        return (OsgiCommandSupport)this.getClass().newInstance();
    }

    public void init(CommandContext context) {
        assert (context != null);
        this.context = context;
        this.io = context.getIO();
        this.variables = context.getVariables();
        String id = this.getId();
        this.log = LoggerFactory.getLogger((String)(this.getClass().getName() + "." + id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doExecute(Object ... args) throws Exception {
        assert (args != null);
        this.log.info("Executing w/args: [{}]", (Object)Arguments.asString(args));
        CommandLineProcessor clp = new CommandLineProcessor(this);
        clp.process(Arguments.toStringArray(args));
        if (this.displayHelp) {
            this.displayHelp(clp);
            return SUCCESS;
        }
        assert (this.io != null);
        assert (this.variables != null);
        try {
            Object object = this.doExecute();
            return object;
        }
        finally {
            this.ungetServices();
        }
    }

    protected abstract Object doExecute() throws Exception;

    protected void displayHelp(CommandLineProcessor clp) {
        assert (clp != null);
        this.io.out.println(this.getId());
        this.io.out.println(" -- ");
        this.io.out.println();
        Printer printer = new Printer(clp);
        printer.printUsage(this.io.out);
        this.io.out.println();
    }

    protected <T> List<T> getAllServices(Class<T> clazz, String filter) throws Exception {
        ServiceReference[] references = this.getBundleContext().getAllServiceReferences(clazz.getName(), filter);
        if (references == null) {
            return null;
        }
        ArrayList<T> services = new ArrayList<T>();
        for (ServiceReference ref : references) {
            T t = this.getService(clazz, ref);
            services.add(t);
        }
        return services;
    }

    protected <T> T getService(Class<T> clazz, ServiceReference reference) {
        Object t = this.getBundleContext().getService(reference);
        if (t != null) {
            if (this.usedReferences == null) {
                this.usedReferences = new ArrayList<ServiceReference>();
            }
            this.usedReferences.add(reference);
        }
        return (T)t;
    }

    protected void ungetServices() {
        if (this.usedReferences != null) {
            for (ServiceReference ref : this.usedReferences) {
                this.getBundleContext().ungetService(ref);
            }
        }
    }
}

