/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.url;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.geronimo.gshell.url.URLHandlerFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=URLHandlerFactory.class, instantiationStrategy="singleton-keep-alive")
public class DefaultURLHandlerFactory
implements URLHandlerFactory,
Initializable {
    private static DefaultURLHandlerFactory SINGLETON;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Factory factory = new Factory();
    @Requirement(role=URLStreamHandler.class)
    private Map<String, URLStreamHandler> handlers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultURLHandlerFactory() {
        Class<URLHandlerFactory> clazz = URLHandlerFactory.class;
        synchronized (URLHandlerFactory.class) {
            if (SINGLETON != null) {
                throw new IllegalStateException("Singleton instance already constructed");
            }
            SINGLETON = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void initialize() throws InitializationException {
        try {
            URL.setURLStreamHandlerFactory(this.factory);
            this.log.debug("URL stream handler factory installed");
        }
        catch (Throwable t) {
            throw new InitializationException("Failed to install URL stream handler factory", t);
        }
        if (!this.handlers.isEmpty()) {
            this.log.debug("Initial URL stream handlers:");
            for (Map.Entry<String, URLStreamHandler> entry : this.handlers.entrySet()) {
                this.log.debug("    {} -> {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        } else {
            this.log.warn("No URL stream handlers are currently registered; somethings probably misconfigured");
        }
    }

    @Override
    public void register(String protocol, URLStreamHandler handler) {
        this.factory.register(protocol, handler);
    }

    @Override
    public URLStreamHandler create(String protocol) {
        return this.factory.getHandler(protocol);
    }

    @Override
    public Map<String, URLStreamHandler> handlers() {
        return this.factory.handlers();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Factory
    implements URLStreamHandlerFactory {
        private final List<String> handlerPackages = new LinkedList<String>();

        private Factory() {
            String systemPackages = System.getProperty("java.protocol.handler.pkgs");
            if (systemPackages != null) {
                StringTokenizer stok = new StringTokenizer(systemPackages, "|");
                while (stok.hasMoreTokens()) {
                    this.handlerPackages.add(stok.nextToken().trim());
                }
            }
            this.handlerPackages.add("sun.net.www.protocol");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            URLStreamHandler handler;
            assert (protocol != null);
            protocol = protocol.trim();
            DefaultURLHandlerFactory.this.log.trace("Create URL stream handler: {}", (Object)protocol);
            Factory factory = this;
            synchronized (factory) {
                handler = (URLStreamHandler)DefaultURLHandlerFactory.this.handlers.get(protocol);
            }
            if (handler != null) {
                DefaultURLHandlerFactory.this.log.trace("Using registered handler: {}", (Object)handler);
                return handler;
            }
            Class<?> type = this.findProtocolHandler(protocol);
            if (type == null) {
                throw new IllegalArgumentException("Unknown protocol: " + protocol);
            }
            try {
                return (URLStreamHandler)type.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to construct handler for protocol: " + protocol, e);
            }
        }

        private synchronized void register(String protocol, URLStreamHandler handler) {
            assert (protocol != null);
            assert (handler != null);
            if (DefaultURLHandlerFactory.this.handlers.containsKey(protocol)) {
                throw new IllegalStateException("Protocol already has a registered handler: " + protocol);
            }
            DefaultURLHandlerFactory.this.handlers.put(protocol, handler);
            DefaultURLHandlerFactory.this.log.debug("Registered {} -> {}", (Object)protocol, (Object)handler);
        }

        private synchronized URLStreamHandler getHandler(String protocol) {
            assert (protocol != null);
            return (URLStreamHandler)DefaultURLHandlerFactory.this.handlers.get(protocol);
        }

        private synchronized Map<String, URLStreamHandler> handlers() {
            return Collections.unmodifiableMap(DefaultURLHandlerFactory.this.handlers);
        }

        private Class<?> findProtocolHandler(String protocol) {
            assert (protocol != null);
            DefaultURLHandlerFactory.this.log.trace("Finding protocol handler: {}", (Object)protocol);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            for (String pkg : this.handlerPackages) {
                String classname = pkg + "." + protocol + ".Handler";
                try {
                    return cl.loadClass(classname);
                }
                catch (Throwable ignore) {
                }
            }
            return null;
        }
    }
}

