/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.request;

import java.util.concurrent.TimeUnit;
import org.apache.geronimo.gshell.common.Duration;
import org.apache.geronimo.gshell.whisper.message.Message;
import org.apache.geronimo.gshell.whisper.request.RequestHandle;
import org.apache.geronimo.gshell.whisper.request.ResponseHandle;
import org.apache.geronimo.gshell.whisper.transport.Session;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Requestor {
    private static final Duration DEFAULT_TIMEOUT = new Duration(10L, TimeUnit.SECONDS);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IoSession session;
    private Duration timeout;

    public Requestor(IoSession session, Duration timeout) {
        this.session = session;
        this.timeout = timeout;
    }

    public Requestor(IoSession session) {
        this(session, DEFAULT_TIMEOUT);
    }

    public Requestor(Session session) {
        this(session.getSession(), DEFAULT_TIMEOUT);
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        assert (timeout != null);
        this.timeout = timeout;
    }

    public RequestWriteFuture submit(Message msg, Duration timeout) throws Exception {
        assert (msg != null);
        assert (timeout != null);
        RequestHandle req = new RequestHandle(msg, timeout.getValue(), timeout.getUnit());
        WriteFuture wf = this.session.write((Object)req);
        return new RequestWriteFuture(wf, req);
    }

    public RequestWriteFuture submit(Message msg) throws Exception {
        return this.submit(msg, this.timeout);
    }

    public Message request(Message msg, Duration timeout) throws Exception {
        RequestWriteFuture wf = this.submit(msg, timeout);
        RequestHandle req = wf.getRequest();
        ResponseHandle resp = req.awaitResponse();
        return resp.getMessage();
    }

    public Message request(Message msg) throws Exception {
        return this.request(msg, this.timeout);
    }

    public class RequestWriteFuture
    implements WriteFuture {
        private final WriteFuture delegate;
        private final RequestHandle request;

        public RequestWriteFuture(WriteFuture wf, RequestHandle req) {
            this.delegate = wf;
            this.request = req;
        }

        public RequestHandle getRequest() {
            return this.request;
        }

        public boolean isWritten() {
            return this.delegate.isWritten();
        }

        public void setWritten(boolean written) {
            this.delegate.setWritten(written);
        }

        public IoSession getSession() {
            return this.delegate.getSession();
        }

        public Object getLock() {
            return this.delegate.getLock();
        }

        public void join() {
            this.delegate.join();
        }

        public boolean join(long timeout) {
            return this.delegate.join(timeout);
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void addListener(IoFutureListener listener) {
            this.delegate.addListener(listener);
        }

        public void removeListener(IoFutureListener listener) {
            this.delegate.removeListener(listener);
        }
    }
}

