/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.transport.base;

import java.net.SocketAddress;
import org.apache.geronimo.gshell.common.tostring.ReflectionToStringBuilder;
import org.apache.geronimo.gshell.common.tostring.ToStringStyle;
import org.apache.geronimo.gshell.whisper.request.RequestResponseFilter;
import org.apache.geronimo.gshell.whisper.stream.SessionStreamFilter;
import org.apache.geronimo.gshell.whisper.transport.TransportExceptionMonitor;
import org.apache.geronimo.gshell.whisper.transport.base.AddressFactory;
import org.apache.geronimo.gshell.whisper.transport.base.BaseConfiguration;
import org.apache.geronimo.gshell.whisper.transport.base.SessionBindingFilter;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseService<T extends IoService> {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected AddressFactory addressFactory;
    private IoHandler handler;
    private ThreadModel threadModel;
    private boolean closed;

    protected BaseService(AddressFactory addressFactory) {
        this.addressFactory = addressFactory;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    protected abstract BaseConfiguration getBaseConfiguration();

    protected synchronized IoHandler createHandler() throws Exception {
        return this.getBaseConfiguration().getHandler();
    }

    protected synchronized IoHandler getHandler() throws Exception {
        if (this.handler == null) {
            this.handler = this.createHandler();
        }
        if (this.handler == null) {
            throw new IllegalStateException("Handler has not been configured");
        }
        return this.handler;
    }

    protected synchronized ThreadModel createThreadModel() throws Exception {
        return null;
    }

    protected synchronized ThreadModel getThreadModel() throws Exception {
        if (this.threadModel == null) {
            this.threadModel = this.createThreadModel();
        }
        return this.threadModel;
    }

    protected void configure(IoService service) throws Exception {
        assert (service != null);
        this.log.debug("Configure: {}", (Object)service);
        service.addListener(new IoServiceListener(){

            public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
                BaseService.this.log.debug("Service activated: {}, filters:", (Object)service);
                for (IoFilterChain.Entry entry : service.getFilterChain().getAll()) {
                    BaseService.this.log.debug("    {}", (Object)entry);
                }
            }

            public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
                BaseService.this.log.debug("Service deactivated: {}", (Object)service);
            }

            public void sessionCreated(IoSession session) {
                BaseService.this.log.debug("Session created: {}; filters:", (Object)session);
                for (IoFilterChain.Entry entry : session.getFilterChain().getAll()) {
                    BaseService.this.log.debug("    {}", (Object)entry);
                }
            }

            public void sessionDestroyed(IoSession session) {
                BaseService.this.log.debug("Session destroyed: {}", (Object)session);
            }
        });
        this.configure(service.getDefaultConfig());
        this.configure(service.getFilterChain());
    }

    protected void configure(IoServiceConfig config) throws Exception {
        assert (config != null);
        this.log.debug("Configure: {}", (Object)config);
        ThreadModel threadModel = this.getThreadModel();
        if (threadModel != null) {
            config.setThreadModel(threadModel);
            this.log.debug("Installed custom thread model: {}", (Object)threadModel);
        }
    }

    protected void configure(DefaultIoFilterChainBuilder chain) throws Exception {
        assert (chain != null);
        this.log.debug("Configure: {}", (Object)chain);
        chain.addLast(SessionBindingFilter.class.getSimpleName(), (IoFilter)new SessionBindingFilter());
        chain.addLast(ProtocolCodecFilter.class.getSimpleName(), (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        chain.addLast(LoggingFilter.class.getSimpleName(), (IoFilter)new LoggingFilter());
        chain.addLast(SessionStreamFilter.class.getSimpleName(), (IoFilter)new SessionStreamFilter());
        chain.addLast(RequestResponseFilter.class.getSimpleName(), (IoFilter)new RequestResponseFilter());
    }

    protected void configure(IoSession session) throws Exception {
        assert (session != null);
        this.log.debug("Configure: {}", (Object)session);
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    protected void ensureOpened() {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
    }

    static {
        ExceptionMonitor.setInstance((ExceptionMonitor)new TransportExceptionMonitor());
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
    }
}

