/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.transport.base;

import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geronimo.gshell.whisper.transport.TransportServer;
import org.apache.geronimo.gshell.whisper.transport.base.AddressFactory;
import org.apache.geronimo.gshell.whisper.transport.base.BaseConfiguration;
import org.apache.geronimo.gshell.whisper.transport.base.BaseService;
import org.apache.geronimo.gshell.whisper.transport.base.ThreadPoolModel;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.ThreadModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTransportServer<T extends IoAcceptor>
extends BaseService
implements TransportServer {
    private static final AtomicLong INSTANCE_COUNTER = new AtomicLong(0L);
    protected URI location;
    protected SocketAddress address;
    protected T acceptor;
    private TransportServer.Configuration config;

    protected BaseTransportServer(AddressFactory addressFactory) {
        super(addressFactory);
    }

    protected abstract TransportServer.Configuration createConfiguration();

    @Override
    public synchronized TransportServer.Configuration getConfiguration() {
        if (this.config == null) {
            this.config = this.createConfiguration();
        }
        return this.config;
    }

    @Override
    public synchronized void setConfiguration(TransportServer.Configuration config) {
        assert (config != null);
        this.config = config;
        this.log.debug("Using configuration: {}", (Object)config);
    }

    @Override
    protected synchronized BaseConfiguration getBaseConfiguration() {
        return (BaseConfiguration)((Object)this.getConfiguration());
    }

    @Override
    protected synchronized ThreadModel createThreadModel() throws Exception {
        return new ThreadPoolModel(this.getClass(), INSTANCE_COUNTER);
    }

    protected abstract T createAcceptor() throws Exception;

    synchronized void bind(URI location) throws Exception {
        assert (location != null);
        this.location = location;
        this.address = this.addressFactory.create(location);
        this.bind();
    }

    synchronized void bind() throws Exception {
        this.acceptor = this.createAcceptor();
        this.log.debug("Acceptor: {}", this.acceptor);
        this.configure((IoService)this.acceptor);
        IoHandler handler = this.getHandler();
        this.log.debug("Handler: {}", (Object)handler);
        this.log.info("Binding to: {}", (Object)this.address);
        this.acceptor.bind(this.address, handler);
        this.log.info("Listening on: {}", (Object)this.address);
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public T getAcceptor() {
        return this.acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            this.acceptor.unbind(this.address);
        }
        finally {
            super.close();
        }
    }

    @Override
    public void addListener(TransportServer.Listener listener) {
        assert (listener != null);
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeListener(TransportServer.Listener listener) {
        assert (listener != null);
        throw new UnsupportedOperationException();
    }

    protected static class BaseTransportServerConfiguration
    extends BaseConfiguration
    implements TransportServer.Configuration {
        protected BaseTransportServerConfiguration() {
        }
    }
}

