/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.lang.reflect.Method;
import javax.jbi.component.ComponentContext;

public abstract class Container {
    protected final ComponentContext context;

    protected Container(ComponentContext context) {
        this.context = context;
    }

    public String toString() {
        return this.getType().toString();
    }

    public abstract Type getType();

    public abstract boolean handleTransactions();

    public ClassLoader getSharedLibraryClassLoader(String name) {
        throw new UnsupportedOperationException("Can not access shared libraries");
    }

    public ClassLoader getComponentClassLoader(String name) {
        throw new UnsupportedOperationException("Can not access components");
    }

    public static Container detect(ComponentContext context) {
        try {
            String clName = context.getClass().getName();
            if ("org.apache.servicemix.jbi.framework.ComponentContextImpl".equals(clName)) {
                return new Smx3Container(context);
            }
            if ("org.apache.servicemix.jbi.runtime.impl.ComponentContextImpl".equals(clName)) {
                return new Smx4Container(context);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new UnknownContainer(context);
    }

    public static class UnknownContainer
    extends Container {
        public UnknownContainer(ComponentContext context) {
            super(context);
        }

        public Type getType() {
            return Type.Unknown;
        }

        public boolean handleTransactions() {
            return false;
        }
    }

    public static class Smx4Container
    extends Container {
        public Smx4Container(ComponentContext context) {
            super(context);
        }

        public Type getType() {
            return Type.ServiceMix4;
        }

        public boolean handleTransactions() {
            return false;
        }
    }

    public static class Smx3Container
    extends Container {
        private boolean handleTransactions;
        private Object container;

        public Smx3Container(ComponentContext context) {
            super(context);
            try {
                Method getContainerMth = context.getClass().getMethod("getContainer", new Class[0]);
                this.container = getContainerMth.invoke((Object)context, new Object[0]);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Method isUseNewTransactionModelMth = this.container.getClass().getMethod("isUseNewTransactionModel", new Class[0]);
                Boolean b = (Boolean)isUseNewTransactionModelMth.invoke(this.container, new Object[0]);
                this.handleTransactions = b == false;
            }
            catch (Throwable t) {
                this.handleTransactions = true;
            }
        }

        public Type getType() {
            return Type.ServiceMix3;
        }

        public boolean handleTransactions() {
            return this.handleTransactions;
        }

        public Object getSmx3Container() {
            return this.container;
        }

        public ClassLoader getSharedLibraryClassLoader(String name) {
            try {
                Object registry = this.container.getClass().getMethod("getRegistry", new Class[0]).invoke(this.container, new Object[0]);
                Object sl = registry.getClass().getMethod("getSharedLibrary", String.class).invoke(registry, name);
                return (ClassLoader)sl.getClass().getMethod("getClassLoader", new Class[0]).invoke(sl, new Object[0]);
            }
            catch (Throwable t) {
                return null;
            }
        }

        public ClassLoader getComponentClassLoader(String name) {
            try {
                Object registry = this.container.getClass().getMethod("getRegistry", new Class[0]).invoke(this.container, new Object[0]);
                Object mbean = registry.getClass().getMethod("getComponent", String.class).invoke(registry, name);
                Object cmp = mbean.getClass().getMethod("getComponent", new Class[0]).invoke(mbean, new Object[0]);
                return cmp.getClass().getClassLoader();
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ServiceMix3,
        ServiceMix4,
        Unknown;

    }
}

