/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExternalEndpoint
implements ServiceEndpoint {
    private QName eprElement;
    private String locationUri;
    private QName serviceName;
    private String endpointName;
    private QName[] interfaces = null;

    public ExternalEndpoint(QName eprElement, String locationUri, QName serviceName, String epName, QName[] interfaces) {
        this.eprElement = eprElement;
        this.locationUri = locationUri;
        this.endpointName = epName;
        this.serviceName = serviceName;
        this.interfaces = interfaces;
    }

    public ExternalEndpoint(QName eprElement, String locationUri, QName serviceName, String epName, QName interfaceName) {
        this.eprElement = eprElement;
        this.locationUri = locationUri;
        this.endpointName = epName;
        this.serviceName = serviceName;
        if (interfaceName != null) {
            this.interfaces = new QName[]{interfaceName};
        }
    }

    public DocumentFragment getAsReference(QName operationName) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().newDocument();
            DocumentFragment df = doc.createDocumentFragment();
            Element e = doc.createElementNS(this.eprElement.getNamespaceURI(), this.eprElement.getLocalPart());
            Text t = doc.createTextNode(this.locationUri);
            e.appendChild(t);
            df.appendChild(e);
            return df;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create reference", e);
        }
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public QName[] getInterfaces() {
        return this.interfaces;
    }
}

