/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.jndi.JNDIReferenceFactory;
import org.apache.activemq.jndi.JNDIStorableInterface;
import org.apache.activemq.pool.PooledConnectionFactory;

public class AmqJNDIPooledConnectionFactory
extends PooledConnectionFactory
implements JNDIStorableInterface {
    private Properties properties;

    public synchronized void setProperties(Properties props) {
        this.properties = props;
        this.buildFromProperties(props);
    }

    public synchronized Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.populateProperties(this.properties);
        return this.properties;
    }

    public Reference getReference() throws NamingException {
        return JNDIReferenceFactory.createReference((String)this.getClass().getName(), (JNDIStorableInterface)this);
    }

    public void buildFromProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        ((ActiveMQConnectionFactory)this.getConnectionFactory()).buildFromProperties(properties);
        String temp = properties.getProperty("maximumActive");
        if (temp != null && temp.length() > 0) {
            this.setMaximumActive(Integer.parseInt(temp));
        }
        if ((temp = properties.getProperty("maxConnections")) != null && temp.length() > 0) {
            this.setMaxConnections(Integer.parseInt(temp));
        }
    }

    public void populateProperties(Properties props) {
        ((ActiveMQConnectionFactory)this.getConnectionFactory()).populateProperties(props);
        props.setProperty("maximumActive", Integer.toString(this.getMaximumActive()));
        props.setProperty("maxConnections", Integer.toString(this.getMaxConnections()));
    }
}

