/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.MessageObserver;
import org.apache.servicemix.cxfbc.CxfBcProvider;
import org.apache.servicemix.cxfbc.interceptors.JbiInWsdl1Interceptor;

public class CxfBcProviderMessageObserver
implements MessageObserver {
    ByteArrayOutputStream response = new ByteArrayOutputStream();
    boolean written;
    String contentType;
    private CxfBcProvider providerEndpoint;

    public CxfBcProviderMessageObserver(CxfBcProvider providerEndpoint) {
        this.providerEndpoint = providerEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream getResponseStream() throws Exception {
        CxfBcProviderMessageObserver cxfBcProviderMessageObserver = this;
        synchronized (cxfBcProviderMessageObserver) {
            if (!this.written) {
                this.wait(1000000000L);
            }
        }
        return this.response;
    }

    public String getResponseContentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message message) {
        try {
            boolean txSync;
            NormalizedMessage msg;
            MessageExchange messageExchange = (MessageExchange)message.getExchange().get(MessageExchange.class);
            if (messageExchange.getStatus() != ExchangeStatus.ACTIVE) {
                return;
            }
            this.contentType = (String)message.get((Object)"Content-Type");
            SoapMessage soapMessage = (SoapMessage)this.providerEndpoint.getCxfEndpoint().getBinding().createMessage(message);
            EndpointInfo ei = this.providerEndpoint.getEndpointInfo();
            QName opeName = messageExchange.getOperation();
            BindingOperationInfo boi = null;
            if (opeName == null) {
                if (ei.getBinding().getOperations().size() != 1) throw new org.apache.cxf.interceptor.Fault((Throwable)new Exception("Operation not bound on this MessageExchange"));
                boi = (BindingOperationInfo)ei.getBinding().getOperations().iterator().next();
            } else {
                boi = ei.getBinding().getOperation(messageExchange.getOperation());
            }
            if (boi.getOperationInfo().isOneWay()) {
                return;
            }
            soapMessage.put("org.apache.cxf.client", (Object)true);
            ExchangeImpl cxfExchange = new ExchangeImpl();
            soapMessage.setExchange((Exchange)cxfExchange);
            cxfExchange.put(BindingOperationInfo.class, (Object)boi);
            cxfExchange.put(Endpoint.class, (Object)this.providerEndpoint.getCxfEndpoint());
            PhaseChainCache inboundChainCache = new PhaseChainCache();
            PhaseManager pm = (PhaseManager)this.providerEndpoint.getBus().getExtension(PhaseManager.class);
            ArrayList<Object> inList = new ArrayList<Object>();
            inList.add(new ReadHeadersInterceptor(this.providerEndpoint.getBus()));
            inList.add(new MustUnderstandInterceptor());
            inList.add(new StaxInInterceptor());
            inList.add((Object)new JbiInWsdl1Interceptor(this.providerEndpoint.isUseJBIWrapper(), this.providerEndpoint.isUseSOAPEnvelope()));
            inList.add(new AttachmentInInterceptor());
            PhaseInterceptorChain inChain = inboundChainCache.get(pm.getInPhases(), inList);
            inChain.add(this.providerEndpoint.getInInterceptors());
            inChain.add(this.providerEndpoint.getInFaultInterceptors());
            inChain.add(this.providerEndpoint.getInInterceptors());
            inChain.add(this.providerEndpoint.getInFaultInterceptors());
            soapMessage.setInterceptorChain((InterceptorChain)inChain);
            inChain.doIntercept((Message)soapMessage);
            if (boi.getOperationInfo().isOneWay()) {
                messageExchange.setStatus(ExchangeStatus.DONE);
            } else if (soapMessage.get((Object)"jbiFault") != null && soapMessage.get((Object)"jbiFault").equals(true)) {
                Fault fault = messageExchange.createFault();
                fault.setContent((Source)soapMessage.getContent(Source.class));
                messageExchange.setFault(fault);
                if (soapMessage.get((Object)"faultstring") != null) {
                    messageExchange.setProperty("faultstring", soapMessage.get((Object)"faultstring"));
                }
            } else if (messageExchange instanceof InOut) {
                msg = messageExchange.createMessage();
                msg.setContent((Source)soapMessage.getContent(Source.class));
                this.toNMSAttachments(msg, (Message)soapMessage);
                messageExchange.setMessage(msg, "out");
            } else if (messageExchange instanceof InOptionalOut) {
                if (soapMessage.getContent(Source.class) != null) {
                    msg = messageExchange.createMessage();
                    msg.setContent((Source)soapMessage.getContent(Source.class));
                    this.toNMSAttachments(msg, (Message)soapMessage);
                    messageExchange.setMessage(msg, "out");
                } else {
                    messageExchange.setStatus(ExchangeStatus.DONE);
                }
            } else {
                messageExchange.setStatus(ExchangeStatus.DONE);
            }
            boolean bl = txSync = messageExchange.getStatus() == ExchangeStatus.ACTIVE && messageExchange.isTransacted() && Boolean.TRUE.equals(messageExchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.providerEndpoint.getContext().getDeliveryChannel().sendSync(messageExchange);
                return;
            } else {
                this.providerEndpoint.getContext().getDeliveryChannel().send(messageExchange);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            CxfBcProviderMessageObserver cxfBcProviderMessageObserver = this;
            synchronized (cxfBcProviderMessageObserver) {
                this.written = true;
                this.notifyAll();
            }
        }
    }

    private void toNMSAttachments(NormalizedMessage normalizedMessage, Message soapMessage) throws MessagingException {
        if (soapMessage.getAttachments() != null) {
            for (Attachment att : soapMessage.getAttachments()) {
                normalizedMessage.addAttachment(att.getId(), att.getDataHandler());
            }
        }
    }
}

