/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSAUtils {
    public static final String WSA_HEADERS_INBOUND = "javax.xml.ws.addressing.context.inbound";
    public static final String WSA_HEADERS_OUTBOUND = "javax.xml.ws.addressing.context.outbound";
    private static final ObjectFactory WSA_OBJECT_FACTORY = new ObjectFactory();

    private WSAUtils() {
    }

    public static AddressingProperties getCXFAddressingPropertiesFromMap(Map<String, String> wsAddressingAsMap) {
        AddressingPropertiesImpl maps = new AddressingPropertiesImpl();
        if (wsAddressingAsMap == null) {
            return maps;
        }
        for (String wsaHeaderKey : wsAddressingAsMap.keySet()) {
            AttributedURIType aAttributedURIType;
            String wsaHeaderValue = wsAddressingAsMap.get(wsaHeaderKey);
            System.out.println(" WSA HEADER KEY -> " + wsaHeaderKey);
            System.out.println(" WSA HEADER VALUE -> " + wsaHeaderKey);
            if ("MessageID".equals(wsaHeaderKey)) {
                aAttributedURIType = WSA_OBJECT_FACTORY.createAttributedURIType();
                aAttributedURIType.setValue(wsaHeaderValue);
                maps.setMessageID(aAttributedURIType);
                continue;
            }
            if ("To".equals(wsaHeaderKey)) {
                maps.setTo(EndpointReferenceUtils.getEndpointReference((String)wsaHeaderValue));
                continue;
            }
            if ("From".equals(wsaHeaderKey)) {
                maps.setTo(EndpointReferenceUtils.getEndpointReference((String)wsaHeaderValue));
                continue;
            }
            if ("ReplyTo".equals(wsaHeaderKey)) {
                maps.setReplyTo(EndpointReferenceUtils.getEndpointReference((String)wsaHeaderValue));
                continue;
            }
            if ("FaultTo".equals(wsaHeaderKey)) {
                maps.setFaultTo(EndpointReferenceUtils.getEndpointReference((String)wsaHeaderValue));
                continue;
            }
            if ("RelatesTo".equals(wsaHeaderKey)) {
                RelatesToType aRelatesToType = WSA_OBJECT_FACTORY.createRelatesToType();
                aRelatesToType.setValue(wsaHeaderValue);
                maps.setRelatesTo(aRelatesToType);
                continue;
            }
            if (!"Action".equals(wsaHeaderKey)) continue;
            aAttributedURIType = WSA_OBJECT_FACTORY.createAttributedURIType();
            aAttributedURIType.setValue(wsaHeaderValue);
            maps.setAction(aAttributedURIType);
        }
        return maps;
    }

    public static Map<String, String> getAsMap(AddressingProperties maps) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (maps.getMessageID() != null) {
            returnMap.put("MessageID", maps.getMessageID().getValue());
        }
        if (maps.getTo() != null) {
            returnMap.put("To", maps.getTo().getValue());
        }
        if (maps.getFrom() != null) {
            returnMap.put("From", maps.getFrom().getAddress().getValue());
        }
        if (maps.getReplyTo() != null) {
            returnMap.put("ReplyTo", maps.getReplyTo().getAddress().getValue());
        }
        if (maps.getFaultTo() != null) {
            returnMap.put("FaultTo", maps.getFaultTo().getAddress().getValue());
        }
        if (maps.getRelatesTo() != null) {
            returnMap.put("RelatesTo", maps.getRelatesTo().getValue());
        }
        if (maps.getAction() != null) {
            returnMap.put("Action", maps.getAction().getValue());
        }
        return returnMap;
    }
}

