/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.ops4j.lang.NullArgumentException;

class RepositoryURL {
    private final URL m_repositoryURL;
    private final boolean m_snapshotsEnabled;
    private final boolean m_releasesEnabled;

    RepositoryURL(String repositorySpec) throws MalformedURLException {
        NullArgumentException.validateNotEmpty(repositorySpec, true, "Repository spec");
        String[] segments = repositorySpec.split("@");
        StringBuilder urlBuilder = new StringBuilder();
        boolean snapshotEnabled = false;
        boolean releasesEnabled = true;
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].trim().equalsIgnoreCase("snapshots")) {
                snapshotEnabled = true;
                continue;
            }
            if (segments[i].trim().equalsIgnoreCase("noreleases")) {
                releasesEnabled = false;
                continue;
            }
            if (i > 0) {
                urlBuilder.append("@");
            }
            urlBuilder.append(segments[i]);
        }
        String spec = urlBuilder.toString();
        if (!spec.endsWith("\\") && !spec.endsWith("/")) {
            spec = spec + "/";
        }
        this.m_repositoryURL = new URL(spec);
        this.m_snapshotsEnabled = snapshotEnabled;
        this.m_releasesEnabled = releasesEnabled;
    }

    public boolean isReleasesEnabled() {
        return this.m_releasesEnabled;
    }

    public URL toURL() {
        return this.m_repositoryURL;
    }

    public boolean isSnapshotsEnabled() {
        return this.m_snapshotsEnabled;
    }

    public String toString() {
        return this.m_repositoryURL.toString() + ",releases=" + this.m_releasesEnabled + ",snapshots=" + this.m_snapshotsEnabled;
    }
}

