/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics;

import java.util.Collection;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.analytics.PackageDescrFlattener;
import org.drools.analytics.RuleLoader;
import org.drools.analytics.dao.AnalyticsData;
import org.drools.analytics.dao.AnalyticsDataFactory;
import org.drools.analytics.result.AnalysisResult;
import org.drools.analytics.result.AnalysisResultNormal;
import org.drools.analytics.result.ComponentsReportModeller;
import org.drools.analytics.result.ReportModeller;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;

public class Analyzer {
    private AnalysisResult result = new AnalysisResultNormal();

    public void addPackageDescr(PackageDescr descr) {
        try {
            PackageDescrFlattener ruleFlattener = new PackageDescrFlattener();
            ruleFlattener.insert(descr);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void fireAnalysis() {
        try {
            AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
            System.setProperty("drools.accumulate.function.validatePattern", "org.drools.analytics.accumulateFunction.ValidatePattern");
            RuleBase ruleBase = Analyzer.createRuleBase();
            StatefulSession workingMemory = ruleBase.newStatefulSession();
            for (Object object : data.getAll()) {
                workingMemory.insert(object);
            }
            workingMemory.setGlobal("data", data);
            workingMemory.setGlobal("result", this.result);
            workingMemory.fireAllRules();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getResultAsPlainText() {
        return ReportModeller.writePlainText(this.result);
    }

    public String getResultAsXML() {
        return ReportModeller.writeXML(this.result);
    }

    public void writeComponentsHTML(String path) {
        ComponentsReportModeller.writeHTML(path, this.result);
    }

    public String getResultAsHTML() {
        return ReportModeller.writeHTML(this.result);
    }

    public AnalysisResult getResult() {
        return this.result;
    }

    private static RuleBase createRuleBase() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Collection<Package> packages = RuleLoader.loadPackages();
        for (Package pkg : packages) {
            ruleBase.addPackage(pkg);
        }
        return ruleBase;
    }
}

