/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.drools.RuntimeDroolsException;
import org.drools.base.accumulators.AccumulateFunction;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectConfiguration;
import org.drools.compiler.DialectRegistry;
import org.drools.util.ChainedProperties;

public class PackageBuilderConfiguration {
    private static final String ACCUMULATE_FUNCTION_PREFIX = "drools.accumulate.function.";
    private Map dialectConfigurations;
    private String defaultDialect;
    private ClassLoader classLoader;
    private ChainedProperties chainedProperties;
    private Map accumulateFunctions;
    private File dumpDirectory;

    public PackageBuilderConfiguration(ClassLoader classLoader) {
        this.init(classLoader, null);
    }

    public PackageBuilderConfiguration(Properties properties) {
        this.init(null, properties);
    }

    public PackageBuilderConfiguration(ClassLoader classLoader, Properties properties) {
        this.init(classLoader, properties);
    }

    public PackageBuilderConfiguration() {
        this.init(null, null);
    }

    private void init(ClassLoader classLoader, Properties properties) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.setClassLoader(classLoader);
        this.chainedProperties = new ChainedProperties(this.classLoader, "packagebuilder.conf");
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.dialectConfigurations = new HashMap();
        this.buildDialectConfigurationMap();
        this.buildAccumulateFunctionsMap();
        this.buildDumpDirectory();
    }

    public ChainedProperties getChainedProperties() {
        return this.chainedProperties;
    }

    private void buildDialectConfigurationMap() {
        HashMap dialectProperties = new HashMap();
        this.chainedProperties.mapStartsWith(dialectProperties, "drools.dialect", false);
        this.setDefaultDialect((String)dialectProperties.remove("drools.dialect.default"));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator it = dialectProperties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String str = (String)entry.getKey();
            String dialectName = str.substring(str.lastIndexOf(".") + 1);
            String dialectClass = (String)entry.getValue();
            this.addDialect(dialectName, dialectClass);
        }
    }

    public void addDialect(String dialectName, String dialectClass) {
        try {
            Class<?> cls = this.classLoader.loadClass(dialectClass);
            DialectConfiguration dialectConf = (DialectConfiguration)cls.newInstance();
            dialectConf.init(this);
            this.addDialect(dialectName, dialectConf);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Unable to load dialect '" + dialectClass + ":" + dialectName + "'", e);
        }
    }

    public void addDialect(String dialectName, DialectConfiguration dialectConf) {
        this.dialectConfigurations.put(dialectName, dialectConf);
    }

    public DialectRegistry buildDialectRegistry() {
        DialectRegistry registry = new DialectRegistry();
        Iterator it = this.dialectConfigurations.values().iterator();
        while (it.hasNext()) {
            DialectConfiguration conf = (DialectConfiguration)it.next();
            Dialect dialect = conf.getDialect();
            registry.addDialect(conf.getDialect().getId(), dialect);
        }
        return registry;
    }

    public String getDefaultDialect() {
        return this.defaultDialect;
    }

    public void setDefaultDialect(String defaultDialect) {
        this.defaultDialect = defaultDialect;
    }

    public DialectConfiguration getDialectConfiguration(String name) {
        return (DialectConfiguration)this.dialectConfigurations.get(name);
    }

    public void setDialectConfiguration(String name, DialectConfiguration configuration) {
        this.dialectConfigurations.put(name, configuration);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    private void buildAccumulateFunctionsMap() {
        this.accumulateFunctions = new HashMap();
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, ACCUMULATE_FUNCTION_PREFIX, true);
        Iterator it = temp.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String identifier = ((String)entry.getKey()).trim().substring(ACCUMULATE_FUNCTION_PREFIX.length());
            this.accumulateFunctions.put(identifier, entry.getValue());
        }
    }

    public Map getAccumulateFunctionsMap() {
        return Collections.unmodifiableMap(this.accumulateFunctions);
    }

    public void addAccumulateFunction(String identifier, String className) {
        this.accumulateFunctions.put(identifier, className);
    }

    public void addAccumulateFunction(String identifier, Class clazz) {
        this.accumulateFunctions.put(identifier, clazz.getName());
    }

    public AccumulateFunction getAccumulateFunction(String identifier) {
        String className = (String)this.accumulateFunctions.get(identifier);
        if (className == null) {
            throw new RuntimeDroolsException("No accumulator function found for identifier: " + identifier);
        }
        try {
            Class<?> clazz = this.classLoader.loadClass(className);
            return (AccumulateFunction)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Error loading accumulator function for identifier " + identifier + ". Class " + className + " not found", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Error loading accumulator function for identifier " + identifier + ". Class " + className + " not found", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Error loading accumulator function for identifier " + identifier + ". Class " + className + " not found", e);
        }
    }

    private void buildDumpDirectory() {
        String dumpStr = this.chainedProperties.getProperty("drools.dump.dir", null);
        if (dumpStr != null) {
            this.dumpDirectory = new File(dumpStr);
            if (!(this.dumpDirectory.isDirectory() && this.dumpDirectory.canWrite() && this.dumpDirectory.canRead())) {
                this.dumpDirectory = null;
                throw new RuntimeDroolsException("Drools dump directory is not accessible: " + dumpStr);
            }
        }
    }

    public File getDumpDir() {
        return this.dumpDirectory;
    }

    public void setDumpDir(File dumpDir) {
        if (!(dumpDir.isDirectory() && dumpDir.canWrite() && dumpDir.canRead())) {
            throw new RuntimeDroolsException("Drools dump directory is not accessible: " + dumpDir.toString());
        }
        this.dumpDirectory = dumpDir;
    }
}

