/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.Properties;
import org.drools.StatefulSession;
import org.drools.decisiontable.model.DRLOutput;
import org.drools.decisiontable.model.Package;
import org.drools.decisiontable.parser.Cell;
import org.drools.decisiontable.parser.Column;
import org.drools.decisiontable.parser.DefaultGenerator;
import org.drools.decisiontable.parser.DefaultTemplateContainer;
import org.drools.decisiontable.parser.DefaultTemplateRuleBase;
import org.drools.decisiontable.parser.Generator;
import org.drools.decisiontable.parser.Row;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.TemplateContainer;
import org.drools.decisiontable.parser.TemplateRuleBase;

public class ExternalSheetListener
implements RuleSheetListener {
    private int startRow = -1;
    private boolean tableFinished = false;
    private Row currentRow;
    private Column[] columns;
    private StatefulSession session;
    private TemplateContainer templateContainer;
    private int startCol;
    private Generator generator;

    public ExternalSheetListener(int startRow, int startCol, String template) {
        this(startRow, startCol, new DefaultTemplateContainer(template));
    }

    public ExternalSheetListener(int startRow, int startCol, TemplateContainer tc) {
        this(startRow, startCol, tc, new DefaultTemplateRuleBase(tc));
    }

    public ExternalSheetListener(int startRow, int startCol, TemplateContainer tc, TemplateRuleBase rb) {
        this(startRow, startCol, tc, rb, new DefaultGenerator(tc.getTemplates()));
    }

    public ExternalSheetListener(int startRow, int startCol, TemplateContainer tc, TemplateRuleBase ruleBase, Generator generator) {
        this.startRow = startRow - 1;
        this.startCol = startCol - 1;
        this.columns = tc.getColumns();
        this.templateContainer = tc;
        this.session = ruleBase.newStatefulSession();
        this.generator = generator;
        this.session.setGlobal("generator", generator);
        this.assertColumns();
    }

    private void assertColumns() {
        for (int i = 0; i < this.columns.length; ++i) {
            this.session.insert(this.columns[i]);
        }
    }

    public Properties getProperties() {
        return null;
    }

    public Package getRuleSet() {
        return null;
    }

    public void finishSheet() {
        if (this.currentRow != null) {
            this.session.insert(this.currentRow);
        }
        this.session.fireAllRules();
        this.session.dispose();
    }

    public void newCell(int row, int column, String value, int mergedColStart) {
        if (this.currentRow != null && column >= this.startCol && value != null && value.trim().length() > 0) {
            int columnIndex = column - this.startCol;
            Cell cell = this.currentRow.getCell(columnIndex);
            cell.setValue(value);
            cell.insert(this.session);
        }
    }

    public void newRow(int rowNumber, int columnCount) {
        if (!this.tableFinished && rowNumber >= this.startRow) {
            if (this.currentRow != null && this.currentRow.isEmpty()) {
                this.currentRow = null;
                this.tableFinished = true;
            } else {
                if (this.currentRow != null) {
                    this.session.insert(this.currentRow);
                }
                this.currentRow = new Row(rowNumber, this.columns);
            }
        }
    }

    public void startSheet(String name) {
    }

    public String renderDRL() {
        DRLOutput out = new DRLOutput();
        out.writeLine(this.templateContainer.getHeader());
        out.writeLine(this.generator.getDrl());
        return out.getDRL();
    }
}

