/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.Iterator;
import org.drools.base.evaluators.Operator;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.util.ReflectiveVisitor;

public class MVELDumper
extends ReflectiveVisitor {
    private StringBuffer mvelDump;
    private boolean isDateField;
    private static final String eol = System.getProperty("line.separator");
    private String template;
    private String fieldName;

    public String dump(FieldConstraintDescr fieldConstr) {
        return this.dump(fieldConstr, false);
    }

    public String dump(FieldConstraintDescr fieldConstr, boolean isDateField) {
        this.mvelDump = new StringBuffer();
        this.isDateField = isDateField;
        this.visit(fieldConstr);
        return this.mvelDump.toString();
    }

    public void visitFieldConstraintDescr(FieldConstraintDescr descr) {
        if (!descr.getRestrictions().isEmpty()) {
            this.fieldName = descr.getFieldName();
            this.mvelDump.append(this.processFieldConstraint(descr.getRestriction()));
        }
    }

    public void visitVariableRestrictionDescr(VariableRestrictionDescr descr) {
        this.template = this.processRestriction(descr.getEvaluator(), descr.getIdentifier());
    }

    public void visitFieldBindingDescr(FieldBindingDescr descr) {
    }

    public void visitLiteralRestrictionDescr(LiteralRestrictionDescr descr) {
        String text = descr.getText();
        if (text == null || descr.getType() == 1) {
            text = "null";
        } else if (descr.getType() == 2) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                text = "\"" + text + "\"";
            }
        } else if (descr.getType() == 3) {
            text = "\"" + text + "\"";
            if (this.isDateField) {
                text = "org.drools.base.evaluators.DateFactory.parseDate( " + text + " )";
            }
        }
        this.template = this.processRestriction(descr.getEvaluator(), text);
    }

    public void visitQualifiedIdentifierRestrictionDescr(QualifiedIdentifierRestrictionDescr descr) {
        this.template = this.processRestriction(descr.getEvaluator(), descr.getText());
    }

    public void visitRestrictionConnectiveDescr(RestrictionConnectiveDescr descr) {
        this.template = "( " + this.processFieldConstraint(descr) + " )";
    }

    public void visitPredicateDescr(PredicateDescr descr) {
        this.template = "eval( " + descr.getContent() + " )";
    }

    public void visitReturnValueRestrictionDescr(ReturnValueRestrictionDescr descr) {
        this.template = this.processRestriction(descr.getEvaluator(), "( " + descr.getContent().toString() + " )");
    }

    private String processFieldConstraint(RestrictionConnectiveDescr restriction) {
        String descrString = "";
        String connective = null;
        connective = restriction.getConnective() == 1 ? " || " : " && ";
        Iterator it = restriction.getRestrictions().iterator();
        while (it.hasNext()) {
            Object temp = it.next();
            this.visit(temp);
            descrString = descrString + this.template;
            if (!it.hasNext()) continue;
            descrString = descrString + connective;
        }
        return descrString;
    }

    private String processRestriction(String evaluator, String value) {
        Operator op = Operator.determineOperator(evaluator);
        if (op == Operator.MEMBEROF) {
            evaluator = "contains";
            return this.evaluatorPrefix(evaluator) + value + " " + this.evaluator(evaluator) + " " + this.fieldName + this.evaluatorSufix(evaluator);
        }
        if (op == Operator.NOTMEMBEROF) {
            evaluator = "not contains";
            return this.evaluatorPrefix(evaluator) + value + " " + this.evaluator(evaluator) + " " + this.fieldName + this.evaluatorSufix(evaluator);
        }
        if (op == Operator.EXCLUDES) {
            evaluator = "not contains";
            return this.evaluatorPrefix(evaluator) + this.fieldName + " " + this.evaluator(evaluator) + " " + value + this.evaluatorSufix(evaluator);
        }
        if (op == Operator.MATCHES) {
            evaluator = "~=";
            return this.evaluatorPrefix(evaluator) + this.fieldName + " " + this.evaluator(evaluator) + " " + value.replaceAll("\\\\", "\\\\\\\\") + this.evaluatorSufix(evaluator);
        }
        if (op == Operator.NOT_MATCHES) {
            evaluator = "not ~=";
            return this.evaluatorPrefix(evaluator) + this.fieldName + " " + this.evaluator(evaluator) + " " + value.replaceAll("\\\\", "\\\\\\\\") + this.evaluatorSufix(evaluator);
        }
        return this.evaluatorPrefix(evaluator) + this.fieldName + " " + this.evaluator(evaluator) + " " + value + this.evaluatorSufix(evaluator);
    }

    private String evaluatorPrefix(String evaluator) {
        if (evaluator.startsWith("not")) {
            return "!( ";
        }
        return "";
    }

    private String evaluator(String evaluator) {
        if (evaluator.startsWith("not")) {
            return evaluator.substring(4);
        }
        return evaluator;
    }

    private String evaluatorSufix(String evaluator) {
        if (evaluator.startsWith("not")) {
            return " )";
        }
        return "";
    }
}

