/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.drools.repository.CategoryItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.VersionableItem;

public abstract class CategorisableItem
extends VersionableItem {
    public CategorisableItem(RulesRepository rulesRepository, Node node) {
        super(rulesRepository, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategory(String tag) throws RulesRepositoryException {
        try {
            this.checkIsUpdateable();
            CategoryItem tagItem = this.rulesRepository.loadCategory(tag);
            int i = 0;
            Value[] newTagValues = null;
            try {
                Property tagReferenceProperty = this.node.getProperty("drools:categoryReference");
                Value[] oldTagValues = tagReferenceProperty.getValues();
                newTagValues = new Value[oldTagValues.length + 1];
                for (i = 0; i < oldTagValues.length; ++i) {
                    if (oldTagValues[i].getString().equals(tag)) {
                        this.log.info((Object)("tag '" + tag + "' already existed for rule node: " + this.node.getName()));
                        return;
                    }
                    newTagValues[i] = oldTagValues[i];
                }
            }
            catch (PathNotFoundException e) {
                newTagValues = new Value[1];
            }
            finally {
                if (newTagValues != null) {
                    newTagValues[i] = this.node.getSession().getValueFactory().createValue(tagItem.getNode());
                    this.updateCategories(newTagValues);
                } else {
                    this.log.error((Object)("reached expected path of execution when adding tag '" + tag + "' to ruleNode: " + this.node.getName()));
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    private void updateCategories(Value[] newTagValues) throws UnsupportedRepositoryOperationException, LockException, RepositoryException, ValueFormatException, VersionException, ConstraintViolationException {
        this.node.checkout();
        this.node.setProperty("drools:categoryReference", newTagValues);
    }

    public void updateCategoryList(String[] categories) {
        this.checkIsUpdateable();
        try {
            Value[] newCats = new Value[categories.length];
            for (int i = 0; i < categories.length; ++i) {
                CategoryItem item = this.rulesRepository.loadCategory(categories[i]);
                newCats[i] = this.node.getSession().getValueFactory().createValue(item.getNode());
            }
            this.updateCategories(newCats);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public List getCategories() throws RulesRepositoryException {
        try {
            Node ruleNode = this.getVersionContentNode();
            ArrayList<CategoryItem> returnList = new ArrayList<CategoryItem>();
            try {
                Property tagReferenceProperty = ruleNode.getProperty("drools:categoryReference");
                Value[] tagValues = tagReferenceProperty.getValues();
                for (int i = 0; i < tagValues.length; ++i) {
                    try {
                        Node tagNode = this.node.getSession().getNodeByUUID(tagValues[i].getString());
                        CategoryItem tagItem = new CategoryItem(this.rulesRepository, tagNode);
                        returnList.add(tagItem);
                        continue;
                    }
                    catch (ItemNotFoundException e) {
                        this.log.debug((Object)"Was unable to load a category by UUID - must have been removed.");
                    }
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            return returnList;
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Error loading cateories", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void removeCategory(String tag) throws RulesRepositoryException {
        try {
            Value[] newTagValues;
            block16: {
                block19: {
                    block17: {
                        if (this.node.getPrimaryNodeType().getName().equals("nt:version")) {
                            String message = "Error. Tags can only be removed from the head version of a rule node";
                            this.log.error((Object)message);
                            throw new RulesRepositoryException(message);
                        }
                        int i = 0;
                        int j = 0;
                        newTagValues = null;
                        try {
                            Node tagNode;
                            Property tagReferenceProperty = this.node.getProperty("drools:categoryReference");
                            Value[] oldTagValues = tagReferenceProperty.getValues();
                            boolean wasThere = false;
                            for (i = 0; i < oldTagValues.length; ++i) {
                                tagNode = this.node.getSession().getNodeByUUID(oldTagValues[i].getString());
                                if (!tagNode.getName().equals(tag)) continue;
                                wasThere = true;
                            }
                            if (wasThere) {
                                newTagValues = new Value[oldTagValues.length + 1];
                                for (i = 0; i < oldTagValues.length; ++i) {
                                    tagNode = this.node.getSession().getNodeByUUID(oldTagValues[i].getString());
                                    if (tagNode.getName().equals(tag)) continue;
                                    newTagValues[j] = oldTagValues[i];
                                    ++j;
                                }
                                break block16;
                            }
                            if (newTagValues == null) break block17;
                        }
                        catch (PathNotFoundException e) {
                            if (newTagValues != null) {
                                this.checkout();
                                this.node.setProperty("drools:categoryReference", newTagValues);
                            } else {
                                this.log.error((Object)("reached expected path of execution when removing tag '" + tag + "' from ruleNode: " + this.node.getName()));
                            }
                            return;
                            catch (Throwable throwable) {
                                if (newTagValues != null) {
                                    this.checkout();
                                    this.node.setProperty("drools:categoryReference", newTagValues);
                                } else {
                                    this.log.error((Object)("reached expected path of execution when removing tag '" + tag + "' from ruleNode: " + this.node.getName()));
                                }
                                throw throwable;
                            }
                        }
                        this.checkout();
                        this.node.setProperty("drools:categoryReference", newTagValues);
                        break block19;
                    }
                    this.log.error((Object)("reached expected path of execution when removing tag '" + tag + "' from ruleNode: " + this.node.getName()));
                }
                return;
            }
            if (newTagValues != null) {
                this.checkout();
                this.node.setProperty("drools:categoryReference", newTagValues);
            } else {
                this.log.error((Object)("reached expected path of execution when removing tag '" + tag + "' from ruleNode: " + this.node.getName()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }
}

