/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import org.apache.log4j.Logger;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;

public class RulesRepository {
    public static final String DEFAULT_PACKAGE = "defaultPackage";
    public static final String DROOLS_URI = "http://www.jboss.org/drools-repository/1.0";
    private static final Logger log = Logger.getLogger((Class)RulesRepository.class);
    public static final String RULE_PACKAGE_AREA = "drools:package_area";
    public static final String PACKAGE_SNAPSHOT_AREA = "drools:packagesnapshot_area";
    public static final String TAG_AREA = "drools:tag_area";
    public static final String STATE_AREA = "drools:state_area";
    public static final String RULES_REPOSITORY_NAME = "drools:repository";
    private Session session;

    public RulesRepository(Session session) {
        this.session = session;
    }

    protected static Node addNodeIfNew(Node parent, String nodeName, String type) throws RulesRepositoryException {
        Node node;
        try {
            node = parent.getNode(nodeName);
        }
        catch (PathNotFoundException e) {
            try {
                log.debug((Object)new StringBuilder().append("Adding new node of type: ").append(type).append(" named: ").append(nodeName).append(" to parent node named ").append(parent.getName()));
                node = parent.addNode(nodeName, type);
            }
            catch (Exception e1) {
                log.error((Object)"Caught Exception", (Throwable)e);
                throw new RulesRepositoryException(e1);
            }
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
        return node;
    }

    public void logout() {
        this.session.logout();
    }

    private Node getAreaNode(String areaName) throws RulesRepositoryException {
        Node folderNode = null;
        int tries = 0;
        while (folderNode == null && tries < 2) {
            try {
                ++tries;
                folderNode = this.session.getRootNode().getNode("drools:repository/" + areaName);
            }
            catch (PathNotFoundException e) {
                if (tries == 1) {
                    log.warn((Object)"The repository appears to have become corrupted.");
                    throw new RulesRepositoryException("Unable to get the main rule repo node. Repository is not setup correctly.", e);
                }
                log.error((Object)"Unable to correct repository corruption");
            }
            catch (Exception e) {
                log.error((Object)"Caught Exception", (Throwable)e);
                throw new RulesRepositoryException("Caught exception " + e.getClass().getName(), e);
            }
        }
        if (folderNode == null) {
            String message = "Could not get a reference to a node for drools:repository/" + areaName;
            log.error((Object)message);
            throw new RulesRepositoryException(message);
        }
        return folderNode;
    }

    public String copyAsset(String uuidSource, String destinationPackage, String destinationName) {
        try {
            AssetItem source = this.loadAssetByUUID(uuidSource);
            String sourcePath = source.getNode().getPath();
            String destPath = this.getAreaNode(RULE_PACKAGE_AREA).getPath() + "/" + destinationPackage + "/" + "assets" + "/" + destinationName;
            this.session.getWorkspace().copy(sourcePath, destPath);
            AssetItem dest = this.loadPackage(destinationPackage).loadAsset(destinationName);
            dest.updateStringProperty(destinationPackage, "drools:packageName");
            dest.node.setProperty("drools:versionNumber", 0L);
            dest.checkin("Copied from " + source.getPackageName() + "/" + source.getName());
            return dest.getUUID();
        }
        catch (RepositoryException e) {
            log.error((Object)"Unable to copy asset.", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public PackageItem loadPackage(String name) throws RulesRepositoryException {
        try {
            Node folderNode = this.getAreaNode(RULE_PACKAGE_AREA);
            Node rulePackageNode = folderNode.getNode(name);
            return new PackageItem(this, rulePackageNode);
        }
        catch (RepositoryException e) {
            log.error((Object)"Unable to load a rule package. ", (Throwable)e);
            throw new RulesRepositoryException("Unable to load a rule package. ", e);
        }
    }

    public boolean containsPackage(String name) {
        Node folderNode = this.getAreaNode(RULE_PACKAGE_AREA);
        try {
            return folderNode.hasNode(name);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public PackageItem loadPackageSnapshot(String packageName, String snapshotName) {
        try {
            Node n = this.getAreaNode(PACKAGE_SNAPSHOT_AREA).getNode(packageName).getNode(snapshotName);
            return new PackageItem(this, n);
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void createPackageSnapshot(String packageName, String snapshotName) {
        log.debug((Object)("Creating snapshot for [" + packageName + "] called [" + snapshotName + "]"));
        try {
            Node snaps = this.getAreaNode(PACKAGE_SNAPSHOT_AREA);
            if (!snaps.hasNode(packageName)) {
                snaps.addNode(packageName, "nt:folder");
                this.save();
            }
            Node pkgSnaps = snaps.getNode(packageName);
            String newName = pkgSnaps.getPath() + "/" + snapshotName;
            Node folderNode = this.getAreaNode(RULE_PACKAGE_AREA);
            Node rulePackageNode = folderNode.getNode(packageName);
            String source = rulePackageNode.getPath();
            this.session.getWorkspace().copy(source, newName);
        }
        catch (RepositoryException e) {
            log.error((Object)"Unable to create snapshot", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void removePackageSnapshot(String packageName, String snapshotName) {
        log.debug((Object)("Removing snapshot for [" + packageName + "] called [" + snapshotName + "]"));
        try {
            Node snaps = this.getAreaNode(PACKAGE_SNAPSHOT_AREA);
            if (!snaps.hasNode(packageName)) {
                throw new RulesRepositoryException("The package " + packageName + " does not have any snapshots.");
            }
            Node pkgSnaps = snaps.getNode(packageName);
            if (pkgSnaps.hasNode(snapshotName)) {
                pkgSnaps.getNode(snapshotName).remove();
            }
            this.save();
        }
        catch (RepositoryException e) {
            log.error((Object)"Unable to remove snapshot", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void copyPackageSnapshot(String packageName, String snapshotName, String newName) {
        log.debug((Object)("Creating snapshot for [" + packageName + "] called [" + snapshotName + "]"));
        try {
            Node snaps = this.getAreaNode(PACKAGE_SNAPSHOT_AREA);
            Node pkgSnaps = snaps.getNode(packageName);
            Node sourceNode = pkgSnaps.getNode(snapshotName);
            String destinationPath = pkgSnaps.getPath() + "/" + newName;
            this.session.getWorkspace().copy(sourceNode.getPath(), destinationPath);
        }
        catch (RepositoryException e) {
            log.error((Object)"Unable to create snapshot", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public PackageItem loadDefaultPackage() throws RulesRepositoryException {
        Node folderNode = this.getAreaNode(RULE_PACKAGE_AREA);
        try {
            if (folderNode.hasNode(DEFAULT_PACKAGE)) {
                return this.loadPackage(DEFAULT_PACKAGE);
            }
            return this.createPackage(DEFAULT_PACKAGE, "");
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public PackageItem loadPackageByUUID(String uuid) throws RulesRepositoryException {
        try {
            Node rulePackageNode = this.session.getNodeByUUID(uuid);
            return new PackageItem(this, rulePackageNode);
        }
        catch (Exception e) {
            log.error((Object)"Unable to load a rule package by UUID. ", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException("Unable to load a rule package. ", e);
        }
    }

    public void restoreHistoricalAsset(AssetItem versionToRestore, AssetItem headVersion, String comment) {
        long oldVersionNumber = headVersion.getVersionNumber();
        Version v = (Version)versionToRestore.getNode();
        try {
            headVersion.getNode().restore(v, true);
            AssetItem newHead = this.loadAssetByUUID(headVersion.getUUID());
            newHead.checkout();
            newHead.getNode().setProperty("drools:versionNumber", oldVersionNumber);
            newHead.checkin(comment);
        }
        catch (RepositoryException e) {
            log.error((Object)"Unable to restore version of asset.", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItem loadAssetByUUID(String uuid) {
        try {
            Node rulePackageNode = this.session.getNodeByUUID(uuid);
            return new AssetItem(this, rulePackageNode);
        }
        catch (RepositoryException e) {
            log.error((Object)"Unable to load a rule asset by UUID.", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public PackageItem createPackage(String name, String description) throws RulesRepositoryException {
        Node folderNode = this.getAreaNode(RULE_PACKAGE_AREA);
        try {
            Node rulePackageNode = folderNode.addNode(name, "drools:packageNodeType");
            rulePackageNode.addNode("assets", "drools:versionableAssetFolder");
            rulePackageNode.setProperty("drools:title", name);
            rulePackageNode.setProperty("drools:description", description);
            rulePackageNode.setProperty("drools:format", "package");
            rulePackageNode.setProperty("drools:creator", this.session.getUserID());
            Calendar lastModified = Calendar.getInstance();
            rulePackageNode.setProperty("drools:lastModified", lastModified);
            PackageItem item = new PackageItem(this, rulePackageNode);
            item.checkin("Initial");
            return item;
        }
        catch (ItemExistsException e) {
            throw new RulesRepositoryException("A package name must be unique.", e);
        }
        catch (RepositoryException e) {
            log.error((Object)"Error when creating a new rule package", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public StateItem getState(String name) throws RulesRepositoryException {
        try {
            Node folderNode = this.getAreaNode(STATE_AREA);
            if (!folderNode.hasNode(name)) {
                throw new RulesRepositoryException("The state called [" + name + "] does not exist.");
            }
            Node stateNode = folderNode.getNode(name);
            return new StateItem(this, stateNode);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RulesRepositoryException(e);
        }
    }

    public StateItem createState(String name) {
        try {
            Node folderNode = this.getAreaNode(STATE_AREA);
            Node stateNode = RulesRepository.addNodeIfNew(folderNode, name, "drools:stateNodeType");
            log.debug((Object)("Created the status [" + name + "]"));
            return new StateItem(this, stateNode);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RulesRepositoryException(e);
        }
    }

    public CategoryItem loadCategory(String tagName) throws RulesRepositoryException {
        if (tagName == null || "".equals(tagName)) {
            throw new RuntimeException("Empty category name not permitted.");
        }
        try {
            Node folderNode;
            Node tagNode = folderNode = this.getAreaNode(TAG_AREA);
            StringTokenizer tok = new StringTokenizer(tagName, "/");
            while (tok.hasMoreTokens()) {
                String currentTagName = tok.nextToken();
                folderNode = tagNode = folderNode.getNode(currentTagName);
            }
            return new CategoryItem(this, tagNode);
        }
        catch (RepositoryException e) {
            if (e instanceof PathNotFoundException) {
                throw new RulesRepositoryException("Unable to load the category : [" + tagName + "] does not exist.", e);
            }
            throw new RulesRepositoryException(e);
        }
    }

    public List findAssetsByCategory(String categoryTag, boolean seekArchivedAsset) throws RulesRepositoryException {
        CategoryItem item = this.loadCategory(categoryTag);
        ArrayList<AssetItem> results = new ArrayList<AssetItem>();
        try {
            PropertyIterator it = item.getNode().getReferences();
            while (it.hasNext()) {
                Property ruleLink = (Property)it.next();
                Node parentNode = ruleLink.getParent();
                if (!this.isNotSnapshot(parentNode) || !parentNode.getPrimaryNodeType().getName().equals("drools:assetNodeType") || !seekArchivedAsset && parentNode.getProperty("drools:archive").getBoolean()) continue;
                results.add(new AssetItem(this, parentNode));
            }
            return results;
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public List findAssetsByCategory(String categoryTag) throws RulesRepositoryException {
        return this.findAssetsByCategory(categoryTag, false);
    }

    public byte[] exportRulesRepository() throws IOException, PathNotFoundException, RepositoryException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(bout);
        zout.putNextEntry(new ZipEntry("repository_export.xml"));
        zout.write(this.dumpRepositoryXml());
        zout.closeEntry();
        zout.finish();
        return bout.toByteArray();
    }

    public byte[] dumpRepositoryXml() throws PathNotFoundException, IOException, RepositoryException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        this.session.refresh(false);
        this.session.exportSystemView("/drools:repository", (OutputStream)byteOut, false, false);
        return byteOut.toByteArray();
    }

    public void importRulesRepository(byte[] byteArray) {
        try {
            new RulesRepositoryAdministrator(this.session).clearRulesRepository();
            this.session.getWorkspace().importXML("/", (InputStream)new ByteArrayInputStream(byteArray), 0);
            this.session.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new RulesRepositoryException();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    boolean isNotSnapshot(Node parentNode) throws RepositoryException {
        return parentNode.getPath().indexOf(PACKAGE_SNAPSHOT_AREA) == -1;
    }

    public Iterator listPackages() {
        Node folderNode = this.getAreaNode(RULE_PACKAGE_AREA);
        try {
            if (!folderNode.hasNode(DEFAULT_PACKAGE)) {
                this.createPackage(DEFAULT_PACKAGE, "The default rule package");
                folderNode = this.getAreaNode(RULE_PACKAGE_AREA);
            }
            return new PackageIterator(this, folderNode.getNodes());
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void save() {
        try {
            this.session.save();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException(e);
        }
    }

    public void moveRuleItemPackage(String newPackage, String uuid, String explanation) {
        try {
            AssetItem item = this.loadAssetByUUID(uuid);
            PackageItem destPkg = this.loadPackage(newPackage);
            String sourcePath = item.node.getPath();
            String destPath = destPkg.node.getPath() + "/" + "assets" + "/" + item.getName();
            this.session.move(sourcePath, destPath);
            item.checkout();
            item.node.setProperty("drools:packageName", newPackage);
            item.checkin(explanation);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public String renameAsset(String uuid, String newAssetName) {
        try {
            AssetItem itemOriginal = this.loadAssetByUUID(uuid);
            log.info((Object)("Renaming asset: " + itemOriginal.getNode().getPath() + " to " + newAssetName));
            Node node = itemOriginal.getNode();
            String sourcePath = node.getPath();
            String destPath = node.getParent().getPath() + "/" + newAssetName;
            this.session.move(sourcePath, destPath);
            itemOriginal.updateTitle(newAssetName);
            itemOriginal.checkin("Renamed asset " + itemOriginal.getName());
            return itemOriginal.getUUID();
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new RulesRepositoryException(e);
        }
    }

    public String renamePackage(String uuid, String newPackageName) {
        try {
            PackageItem itemOriginal = this.loadPackageByUUID(uuid);
            log.info((Object)("Renaming package: " + itemOriginal.getNode().getPath() + " to " + newPackageName));
            Node node = itemOriginal.getNode();
            String sourcePath = node.getPath();
            String destPath = node.getParent().getPath() + "/" + newPackageName;
            this.session.move(sourcePath, destPath);
            itemOriginal.updateTitle(newPackageName);
            itemOriginal.checkin("Renamed package " + itemOriginal.getName());
            PackageItem newPkg = this.loadPackage(newPackageName);
            Iterator iter = newPkg.getAssets();
            while (iter.hasNext()) {
                AssetItem as = (AssetItem)iter.next();
                as.updateStringProperty(newPackageName, "drools:packageName");
            }
            this.save();
            return itemOriginal.getUUID();
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new RulesRepositoryException(e);
        }
    }

    public String[] listPackageSnapshots(String packageName) {
        Node snaps = this.getAreaNode(PACKAGE_SNAPSHOT_AREA);
        try {
            if (!snaps.hasNode(packageName)) {
                return new String[0];
            }
            ArrayList<String> result = new ArrayList<String>();
            NodeIterator it = snaps.getNode(packageName).getNodes();
            while (it.hasNext()) {
                Node element = (Node)it.next();
                result.add(element.getName());
            }
            return result.toArray(new String[result.size()]);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator findArchivedAssets() {
        try {
            String sql = "SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType";
            sql = sql + " WHERE ";
            sql = sql + " jcr:path LIKE '/drools:repository/drools:package_area/%'";
            sql = sql + " AND drools:archive = 'true'";
            Query q = this.session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            QueryResult res = q.execute();
            return new AssetItemIterator(res.getNodes(), this);
        }
        catch (RepositoryException e) {
            System.out.println(e.getMessage());
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator findAssetsByName(String name, boolean seekArchived) {
        try {
            String sql = "SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType";
            sql = sql + " WHERE drools:title LIKE '" + name + "'";
            sql = sql + " AND jcr:path LIKE '/drools:repository/drools:package_area/%'";
            if (!seekArchived) {
                sql = sql + " AND drools:archive = 'false'";
            }
            Query q = this.session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            QueryResult res = q.execute();
            return new AssetItemIterator(res.getNodes(), this);
        }
        catch (RepositoryException e) {
            System.out.println(e.getMessage());
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator findAssetsByName(String name) {
        return this.findAssetsByName(name, false);
    }

    public StateItem[] listStates() {
        ArrayList<StateItem> states = new ArrayList<StateItem>();
        try {
            NodeIterator it = this.getAreaNode(STATE_AREA).getNodes();
            while (it.hasNext()) {
                states.add(new StateItem(this, it.nextNode()));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new RulesRepositoryException(e);
        }
        return states.toArray(new StateItem[states.size()]);
    }

    public void copyPackage(String sourcePackageName, String destPackageName) {
        PackageItem source = this.loadPackage(sourcePackageName);
        try {
            String sourcePath = source.getNode().getPath();
            String destPath = source.getNode().getParent().getPath() + "/" + destPackageName;
            if (this.getAreaNode(RULE_PACKAGE_AREA).hasNode(destPackageName)) {
                throw new RulesRepositoryException("Destination already exists.");
            }
            this.session.getWorkspace().copy(sourcePath, destPath);
            PackageItem newPkg = this.loadPackage(destPackageName);
            Iterator iter = newPkg.getAssets();
            while (iter.hasNext()) {
                AssetItem as = (AssetItem)iter.next();
                as.updateStringProperty(destPackageName, "drools:packageName");
            }
            this.save();
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new RulesRepositoryException(e);
        }
    }
}

