/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scm.svn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.scm.DefaultScmEntry;
import org.drools.scm.ScmAction;
import org.drools.scm.ScmActionFactory;
import org.drools.scm.log.ScmLogEntry;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnActionFactory
implements ScmActionFactory {
    private SVNRepository repository;

    public SVNRepository getSVNRepository() {
        return this.repository;
    }

    public ScmAction addDirectory(String root, String path) {
        return new AddDirectory(root, path);
    }

    public ScmAction addFile(String path, String file, byte[] content) {
        return new AddFile(path, file, content);
    }

    public ScmAction copyDirectory(String path, String newPath, long revision) {
        return new CopyDirectory(path, newPath, revision);
    }

    public ScmAction copyFile(String path, String file, String newPath, String newFile, long revision) {
        return new CopyFile(path, file, newPath, newFile, revision);
    }

    public ScmAction deleteDirectory(String path) {
        return new DeleteDirectory(path);
    }

    public ScmAction deleteFile(String path, String file) {
        return new DeleteFile(path, file);
    }

    public ScmAction moveDirectory(String path, String newPath, long revision) {
        return new MoveDirectory(path, newPath, revision);
    }

    public ScmAction moveFile(String path, String file, String newPath, String newFile, long revision) {
        return new MoveFile(path, file, newPath, newFile, revision);
    }

    public ScmAction updateFile(String path, String file, byte[] oldContent, byte[] newContent) {
        return new UpdateFile(path, file, oldContent, newContent);
    }

    public SvnActionFactory(String url, String svnUsername, String svnPassword) throws Exception {
        String username = svnUsername;
        String password = svnPassword;
        try {
            this.repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
            this.repository.setAuthenticationManager(authManager);
            SVNNodeKind nodeKind = this.repository.checkPath("", -1L);
            if (nodeKind == SVNNodeKind.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"No entry at URL ''{0}''", (Object)url);
                throw new SVNException(err);
            }
            if (nodeKind == SVNNodeKind.FILE) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Entry at URL ''{0}'' is a file while directory was expected", (Object)url);
                throw new SVNException(err);
            }
        }
        catch (SVNException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void getContent(String path, String file, long revision, OutputStream os) throws SVNException {
        this.repository.getFile(path + "/" + file, revision, null, os);
    }

    public List log(String[] paths, long startRevision, long endRevision) throws SVNException {
        return this.toScm(this.repository.log(paths, null, startRevision, endRevision, true, false));
    }

    private List toScm(Collection collection) throws SVNException {
        ArrayList<ScmLogEntry> list = new ArrayList<ScmLogEntry>();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            SVNLogEntry logEntry = (SVNLogEntry)it.next();
            Map map = logEntry.getChangedPaths();
            Set changePathSet = map.keySet();
            ScmLogEntry scmLogEntry = new ScmLogEntry(logEntry.getAuthor(), logEntry.getDate(), logEntry.getMessage());
            Iterator it2 = changePathSet.iterator();
            while (it2.hasNext()) {
                SVNLogEntryPath entryPath = (SVNLogEntryPath)map.get(it2.next());
                switch (entryPath.getType()) {
                    case 'A': {
                        char type;
                        SVNDirEntry dirEntry = this.repository.info(entryPath.getPath(), -1L);
                        char c = type = dirEntry.getKind() == SVNNodeKind.DIR ? (char)'D' : 'F';
                        if (entryPath.getCopyPath() == null) {
                            ScmLogEntry.Add add = new ScmLogEntry.Add(type, entryPath.getPath(), logEntry.getRevision());
                            scmLogEntry.addAction(add);
                            break;
                        }
                        ScmLogEntry.Copy copy = new ScmLogEntry.Copy(type, entryPath.getCopyPath(), entryPath.getCopyRevision(), entryPath.getPath(), logEntry.getRevision());
                        scmLogEntry.addAction(copy);
                        break;
                    }
                    case 'D': {
                        SVNDirEntry dirEntry = this.repository.info(entryPath.getPath(), -1L);
                        char type = dirEntry.getKind() == SVNNodeKind.DIR ? (char)'D' : 'F';
                        ScmLogEntry.Delete delete = new ScmLogEntry.Delete(type, entryPath.getPath(), logEntry.getRevision());
                        scmLogEntry.addAction(delete);
                        break;
                    }
                    case 'M': {
                        SVNDirEntry dirEntry = this.repository.info(entryPath.getPath(), -1L);
                        char type = dirEntry.getKind() == SVNNodeKind.DIR ? (char)'D' : 'F';
                        ScmLogEntry.Update update = new ScmLogEntry.Update(type, entryPath.getPath(), logEntry.getRevision());
                        scmLogEntry.addAction(update);
                        break;
                    }
                    case 'R': {
                        SVNDirEntry dirEntry = this.repository.info(entryPath.getPath(), -1L);
                        char type = dirEntry.getKind() == SVNNodeKind.DIR ? (char)'D' : 'F';
                        ScmLogEntry.Replaced replaced = new ScmLogEntry.Replaced(type, entryPath.getPath(), logEntry.getRevision());
                        scmLogEntry.addAction(replaced);
                        break;
                    }
                }
            }
            list.add(scmLogEntry);
        }
        return list;
    }

    public long getLatestRevision() throws Exception {
        try {
            return this.repository.getLatestRevision();
        }
        catch (SVNException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void execute(ScmAction action, String message) throws Exception {
        try {
            ISVNEditor editor = this.repository.getCommitEditor(message, null);
            editor.openRoot(-1L);
            action.applyAction(editor);
            editor.closeDir();
            SVNCommitInfo info = editor.closeEdit();
        }
        catch (SVNException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void openDirectories(ISVNEditor editor, String path) throws SVNException {
        int pos = path.indexOf(47, 0);
        while (pos != -1) {
            editor.openDir(path.substring(0, pos), -1L);
            pos = path.indexOf(47, pos + 1);
        }
        editor.openDir(path.substring(0, path.length()), -1L);
    }

    public static void closeDirectories(ISVNEditor editor, String path) throws SVNException {
        int length = path.length() - 1;
        int pos = path.lastIndexOf(47, length);
        editor.closeDir();
        while (pos != -1) {
            editor.closeDir();
            pos = path.lastIndexOf(47, pos - 1);
        }
    }

    public List listEntries(String path) throws SVNException {
        ArrayList entries = new ArrayList();
        this.listEntries(path, entries);
        return entries;
    }

    public void listEntries(String path, List list) throws SVNException {
        Collection entries = this.repository.getDir(path, -1L, null, (Collection)null);
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            SVNDirEntry svnEntry = (SVNDirEntry)iterator.next();
            DefaultScmEntry scmEntry = new DefaultScmEntry();
            scmEntry.setPath(path.equals("") ? path : path.substring(1));
            scmEntry.setName(svnEntry.getName());
            scmEntry.setAuthor(svnEntry.getAuthor());
            scmEntry.setDate(svnEntry.getDate());
            scmEntry.setRevision(svnEntry.getRevision());
            scmEntry.setSize(svnEntry.getSize());
            scmEntry.setType(svnEntry.getKind() == SVNNodeKind.DIR ? 0 : 0);
            list.add(scmEntry);
            if (svnEntry.getKind() != SVNNodeKind.DIR) continue;
            this.listEntries(path + "/" + svnEntry.getName(), list);
        }
    }

    static {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public static class CommitMediator
    implements ISVNWorkspaceMediator {
        private Map myTmpStorages = new HashMap();

        public String getWorkspaceProperty(String path, String name) throws SVNException {
            return null;
        }

        public void setWorkspaceProperty(String path, String name, String value) throws SVNException {
        }

        public OutputStream createTemporaryLocation(String path, Object id) throws IOException {
            ByteArrayOutputStream tempStorageOS = new ByteArrayOutputStream();
            this.myTmpStorages.put(id, tempStorageOS);
            return tempStorageOS;
        }

        public InputStream getTemporaryLocation(Object id) throws IOException {
            return new ByteArrayInputStream(((ByteArrayOutputStream)this.myTmpStorages.get(id)).toByteArray());
        }

        public long getLength(Object id) throws IOException {
            ByteArrayOutputStream tempStorageOS = (ByteArrayOutputStream)this.myTmpStorages.get(id);
            if (tempStorageOS != null) {
                return tempStorageOS.size();
            }
            return 0L;
        }

        public void deleteTemporaryLocation(Object id) {
            this.myTmpStorages.remove(id);
        }
    }

    public static class DeleteDirectory
    implements ScmAction {
        private String path;

        public DeleteDirectory(String path) {
            this.path = path;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            SvnActionFactory.openDirectories(editor, this.path);
            editor.deleteEntry(this.path, -1L);
            SvnActionFactory.closeDirectories(editor, this.path);
        }
    }

    public static class DeleteFile
    implements ScmAction {
        private String path;
        private String file;

        public DeleteFile(String path, String file) {
            this.path = path;
            this.file = file;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            SvnActionFactory.openDirectories(editor, this.path);
            editor.deleteEntry(this.path + "/" + this.file, -1L);
            SvnActionFactory.closeDirectories(editor, this.path);
        }
    }

    public static class MoveDirectory
    implements ScmAction {
        private String path;
        private String newPath;
        private long revision;

        public MoveDirectory(String path, String newPath, long revision) {
            this.path = path;
            this.newPath = newPath;
            this.revision = revision;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            CopyDirectory copyDirectory = new CopyDirectory(this.path, this.newPath, this.revision);
            DeleteDirectory deleteDirectory = new DeleteDirectory(this.path);
            copyDirectory.applyAction(editor);
            deleteDirectory.applyAction(editor);
        }
    }

    public static class MoveFile
    implements ScmAction {
        private String file;
        private String path;
        private String newPath;
        private String newFile;
        private long revision;

        public MoveFile(String path, String file, String newPath, String newFile, long revision) {
            this.path = path;
            this.file = file;
            this.newPath = newPath;
            this.newFile = newFile;
            this.revision = revision;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            CopyFile copyFile = new CopyFile(this.path, this.file, this.newPath, this.newFile, this.revision);
            DeleteFile deleteFile = new DeleteFile(this.path, this.file);
            copyFile.applyAction(editor);
            deleteFile.applyAction(editor);
        }
    }

    public static class CopyDirectory
    implements ScmAction {
        private String path;
        private String newPath;
        private long revision;

        public CopyDirectory(String path, String newPath, long revision) {
            this.path = path;
            this.newPath = newPath;
            this.revision = revision;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            editor.addDir(this.newPath, this.path, this.revision);
            editor.closeDir();
        }
    }

    public static class CopyFile
    implements ScmAction {
        private String file;
        private String path;
        private String newPath;
        private String newFile;
        private long revision;

        public CopyFile(String path, String file, String newPath, String newFile, long revision) {
            this.path = path;
            this.file = file;
            this.newPath = newPath;
            this.newFile = newFile;
            this.revision = revision;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            editor.addFile(this.newPath + "/" + this.newFile, this.path + "/" + this.file, this.revision);
        }
    }

    public static class UpdateFile
    implements ScmAction {
        private String file;
        private String path;
        private byte[] oldContent;
        private byte[] newContent;

        public UpdateFile(String path, String file, byte[] oldContent, byte[] newContent) {
            this.path = path;
            this.file = file;
            this.oldContent = oldContent;
            this.newContent = newContent;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            SvnActionFactory.openDirectories(editor, this.path);
            editor.openFile(this.path + "/" + this.file, -1L);
            editor.applyTextDelta(this.path + "/" + this.file, null);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            String checksum = deltaGenerator.sendDelta(this.path + "/" + this.file, (InputStream)new ByteArrayInputStream(this.oldContent), 0L, (InputStream)new ByteArrayInputStream(this.newContent), (ISVNDeltaConsumer)editor, true);
            editor.closeFile(this.path + "/" + this.file, checksum);
            SvnActionFactory.closeDirectories(editor, this.path);
        }
    }

    public static class AddDirectory
    implements ScmAction {
        private String root;
        private String path;

        public AddDirectory(String root, String path) {
            this.root = root;
            this.path = path;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            SvnActionFactory.openDirectories(editor, this.root);
            String[] paths = this.path.split("/");
            String newPath = this.root;
            int length = paths.length;
            for (int i = 0; i < length; ++i) {
                newPath = newPath.length() != 0 ? newPath + "/" + paths[i] : paths[i];
                editor.addDir(newPath, null, -1L);
            }
            SvnActionFactory.closeDirectories(editor, this.path);
            SvnActionFactory.closeDirectories(editor, this.root);
        }
    }

    public static class AddFile
    implements ScmAction {
        private String file;
        private String path;
        private byte[] content;

        public AddFile(String path, String file, byte[] content) {
            this.path = path;
            this.file = file;
            this.content = content;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            SvnActionFactory.openDirectories(editor, this.path);
            editor.addFile(this.path + "/" + this.file, null, -1L);
            editor.applyTextDelta(this.path + "/" + this.file, null);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            String checksum = deltaGenerator.sendDelta(this.path + "/" + this.file, (InputStream)new ByteArrayInputStream(this.content), (ISVNDeltaConsumer)editor, true);
            editor.closeFile(this.path + "/" + this.file, checksum);
            SvnActionFactory.closeDirectories(editor, this.path);
        }
    }
}

