/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import java.io.Serializable;
import java.util.ArrayList;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.ParserContext;
import org.mvel.ast.BlockNode;
import org.mvel.ast.NestedStatement;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;

public class WithNode
extends BlockNode
implements NestedStatement {
    private String nestParm;
    private ExecutableStatement nestedStatement;
    private ParmValuePair[] withExpressions;

    public WithNode(char[] expr, char[] block, int fields) {
        super(expr, fields, block);
        ParserContext pCtx = null;
        if ((fields & 0x10) != 0) {
            pCtx = AbstractParser.getCurrentThreadParserContext();
            pCtx.setBlockSymbols(true);
        }
        this.nestParm = new String(expr).trim();
        this.nestedStatement = (ExecutableStatement)ParseTools.subCompileExpression(this.nestParm);
        this.compileWithExpressions();
        if (pCtx != null) {
            pCtx.setBlockSymbols(false);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object ctxObject = this.nestedStatement.getValue(ctx, thisValue, factory);
        ParmValuePair[] parmValuePairArray = this.withExpressions;
        int n = this.withExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            ParmValuePair pvp = parmValuePairArray[n2];
            if (pvp.getSetExpression() != null) {
                MVEL.executeSetExpression(pvp.getSetExpression(), ctxObject, factory, pvp.getStatement().getValue(ctx, thisValue, factory));
            } else {
                pvp.getStatement().getValue(ctxObject, ctxObject, factory);
            }
            ++n2;
        }
        return ctxObject;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    private void compileWithExpressions() {
        ArrayList<ParmValuePair> parms = new ArrayList<ParmValuePair>();
        int start = 0;
        String parm = "";
        int end = -1;
        int oper = -1;
        int i = 0;
        while (i < this.block.length) {
            switch (this.block[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(this.block, i, this.block[i]);
                    if (i != -1) break;
                    throw new CompileException("unbalanced braces", this.block, i);
                }
                case '*': {
                    if (i >= this.block.length || this.block[i + 1] != '=') break;
                    oper = 2;
                    break;
                }
                case '/': {
                    if (i < this.block.length && this.block[i + 1] == '/') {
                        end = i;
                        while (i < this.block.length && this.block[i] != '\n') {
                            ++i;
                        }
                        if (parm != null) break;
                        start = i;
                        break;
                    }
                    if (i < this.block.length && this.block[i + 1] == '*') {
                        end = i;
                        while (i < this.block.length) {
                            switch (this.block[i++]) {
                                case '*': {
                                    if (i < this.block.length && this.block[i] != '/') break;
                                }
                            }
                        }
                        if (parm != null) break;
                        start = i;
                        break;
                    }
                    if (i >= this.block.length || this.block[i + 1] != '=') break;
                    oper = 3;
                    break;
                }
                case '-': {
                    if (i >= this.block.length || this.block[i + 1] != '=') break;
                    oper = 1;
                    break;
                }
                case '+': {
                    if (i >= this.block.length || this.block[i + 1] != '=') break;
                    oper = 0;
                    break;
                }
                case '=': {
                    parm = new String(this.block, start, i - start - (oper != -1 ? 1 : 0)).trim();
                    start = ++i;
                    break;
                }
                case ',': {
                    if (end == -1) {
                        end = i;
                    }
                    if (parm == null) {
                        parms.add(new ParmValuePair(null, (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(String.valueOf(this.nestParm) + "." + parm, ParseTools.subset(this.block, start, end - start), oper))));
                        oper = -1;
                        start = ++i;
                    } else {
                        parms.add(new ParmValuePair(parm, (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(String.valueOf(this.nestParm) + "." + parm, ParseTools.subset(this.block, start, end - start), oper))));
                        parm = null;
                        oper = -1;
                        start = ++i;
                    }
                    end = -1;
                }
            }
            ++i;
        }
        if (parm != null && start != (end = this.block.length)) {
            parms.add(new ParmValuePair(parm, (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(String.valueOf(this.nestParm) + "." + parm, ParseTools.subset(this.block, start, end - start), oper))));
        }
        this.withExpressions = new ParmValuePair[parms.size()];
        parms.toArray(this.withExpressions);
    }

    public ExecutableStatement getNestedStatement() {
        return this.nestedStatement;
    }

    public ParmValuePair[] getWithExpressions() {
        return this.withExpressions;
    }

    public static final class ParmValuePair
    implements Serializable {
        private Serializable setExpression;
        private ExecutableStatement statement;

        public ParmValuePair() {
        }

        public ParmValuePair(String parameter, ExecutableStatement statement) {
            this.setExpression = MVEL.compileSetExpression(parameter);
            this.statement = statement;
        }

        public Serializable getSetExpression() {
            return this.setExpression;
        }

        public void setSetExpression(Serializable setExpression) {
            this.setExpression = setExpression;
        }

        public ExecutableStatement getStatement() {
            return this.statement;
        }

        public void setStatement(ExecutableStatement statement) {
            this.statement = statement;
        }
    }
}

