/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.integration.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mvel.ParserContext;
import org.mvel.integration.VariableResolver;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.BaseVariableResolverFactory;
import org.mvel.integration.impl.MapVariableResolverFactory;
import org.mvel.integration.impl.SimpleValueResolver;
import org.mvel.util.ParseTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassImportResolverFactory
extends BaseVariableResolverFactory {
    private Set<String> packageImports;

    public ClassImportResolverFactory() {
        this.variableResolvers = new HashMap();
    }

    public ClassImportResolverFactory(ParserContext ctx, VariableResolverFactory nextFactory) {
        this.packageImports = ctx.getPackageImports();
        Map<String, Object> classes = ctx.getImports();
        this.nextFactory = nextFactory;
        this.variableResolvers = new HashMap();
        for (String s : classes.keySet()) {
            this.variableResolvers.put(s, new SimpleValueResolver(classes.get(s)));
        }
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory(new HashMap());
        }
        return this.nextFactory.createVariable(name, value);
    }

    public VariableResolver createVariable(String name, Object value, Class type) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory(new HashMap());
        }
        return this.nextFactory.createVariable(name, value);
    }

    public Class addClass(Class clazz) {
        this.variableResolvers.put(ParseTools.getSimpleClassName(clazz), new SimpleValueResolver(clazz));
        return clazz;
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    @Override
    public boolean isResolveable(String name) {
        if (this.variableResolvers.containsKey(name) || this.isNextResolveable(name)) {
            return true;
        }
        if (this.packageImports != null) {
            for (String s : this.packageImports) {
                try {
                    this.addClass(ParseTools.createClass(new StringBuffer(String.valueOf(s)).append(".").append(name).toString()));
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public void clear() {
        this.variableResolvers.clear();
    }

    public void setImportedClasses(Map<String, Class> imports) {
        if (imports == null) {
            return;
        }
        for (String var : imports.keySet()) {
            this.variableResolvers.put(var, new SimpleValueResolver(imports.get(var)));
        }
    }

    public Map<String, Object> getImportedClasses() {
        HashMap<String, Object> imports = new HashMap<String, Object>();
        for (String var : this.variableResolvers.keySet()) {
            imports.put(var, ((VariableResolver)this.variableResolvers.get(var)).getValue());
        }
        return imports;
    }

    public void addPackageImport(String packageName) {
        if (this.packageImports == null) {
            this.packageImports = new HashSet<String>();
        }
        this.packageImports.add(packageName);
    }
}

