/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class BooleanFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = 400L;
    private static EvaluatorFactory INSTANCE = new BooleanFactory();

    private BooleanFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BooleanFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return BooleanEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return BooleanNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return BooleanMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return BooleanNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for BooleanEvaluator");
    }

    static class BooleanNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BooleanNotMemberOfEvaluator();

        private BooleanNotMemberOfEvaluator() {
            super(ValueType.PBOOLEAN_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "Boolean not memberOf";
        }
    }

    static class BooleanMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BooleanMemberOfEvaluator();

        private BooleanMemberOfEvaluator() {
            super(ValueType.PBOOLEAN_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "Boolean memberOf";
        }
    }

    static class BooleanNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BooleanNotEqualEvaluator();

        private BooleanNotEqualEvaluator() {
            super(ValueType.PBOOLEAN_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getBooleanValue(workingMemory, object1) != object2.getBooleanValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return context.declaration.getExtractor().getBooleanValue(workingMemory, left) != ((VariableRestriction.BooleanVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object object2) {
            if (context.extractor.isNullValue(workingMemory, object2)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return context.extractor.getBooleanValue(workingMemory, object2) != ((VariableRestriction.BooleanVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getBooleanValue(workingMemory, object1) != extractor1.getBooleanValue(workingMemory, object2);
        }

        public String toString() {
            return "Boolean !=";
        }
    }

    static class BooleanEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new BooleanEqualEvaluator();

        private BooleanEqualEvaluator() {
            super(ValueType.PBOOLEAN_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getBooleanValue(workingMemory, object1) == object2.getBooleanValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return context.declaration.getExtractor().getBooleanValue(workingMemory, left) == ((VariableRestriction.BooleanVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object object2) {
            if (context.extractor.isNullValue(workingMemory, object2)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return context.extractor.getBooleanValue(workingMemory, object2) == ((VariableRestriction.BooleanVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getBooleanValue(workingMemory, object1) == extractor2.getBooleanValue(workingMemory, object2);
        }

        public String toString() {
            return "Boolean ==";
        }
    }
}

