/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.ArrayList;
import org.drools.RuleBaseConfiguration;
import org.drools.base.evaluators.Operator;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.FactHandleMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Constraint;
import org.drools.util.AbstractHashTable;
import org.drools.util.FactHandleIndexHashTable;
import org.drools.util.FactHashTable;
import org.drools.util.FactList;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListEntry;
import org.drools.util.TupleHashTable;
import org.drools.util.TupleIndexHashTable;

public class DefaultBetaConstraints
implements Serializable,
BetaConstraints {
    private static final long serialVersionUID = 400L;
    private final LinkedList constraints = new LinkedList();
    private int indexed = -1;

    public DefaultBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf) {
        this(constraints, conf, false);
    }

    public DefaultBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf, boolean disableIndexing) {
        int depth = conf.getCompositeKeyDepth();
        int length = constraints.length;
        for (int i = 0; i < length; ++i) {
            if (!disableIndexing && conf.isIndexLeftBetaMemory() && conf.isIndexRightBetaMemory() && this.isIndexable(constraints[i]) && this.indexed < depth - 1) {
                if (depth >= 1 && this.indexed == -1) {
                    this.constraints.insertAfter(null, new LinkedListEntry(constraints[i]));
                    ++this.indexed;
                    continue;
                }
                this.constraints.insertAfter(this.findNode(this.indexed++), new LinkedListEntry(constraints[i]));
                continue;
            }
            this.constraints.add(new LinkedListEntry(constraints[i]));
        }
    }

    public ContextEntry[] createContext() {
        ContextEntry[] contexts = new ContextEntry[this.constraints.size()];
        int i = 0;
        for (LinkedListEntry entry = (LinkedListEntry)this.constraints.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
            BetaNodeFieldConstraint constraint = (BetaNodeFieldConstraint)entry.getObject();
            contexts[i++] = constraint.createContextEntry();
        }
        return contexts;
    }

    private LinkedListEntry findNode(int pos) {
        LinkedListEntry current = (LinkedListEntry)this.constraints.getFirst();
        for (int i = 0; i < pos; ++i) {
            current = (LinkedListEntry)current.getNext();
        }
        return current;
    }

    private boolean isIndexable(BetaNodeFieldConstraint constraint) {
        if (constraint instanceof VariableConstraint) {
            VariableConstraint variableConstraint = (VariableConstraint)constraint;
            return variableConstraint.getEvaluator().getOperator() == Operator.EQUAL;
        }
        return false;
    }

    public void updateFromTuple(ContextEntry[] context, InternalWorkingMemory workingMemory, ReteTuple tuple) {
        for (int i = 0; i < context.length; ++i) {
            context[i].updateFromTuple(workingMemory, tuple);
        }
    }

    public void updateFromFactHandle(ContextEntry[] context, InternalWorkingMemory workingMemory, InternalFactHandle handle) {
        for (int i = 0; i < context.length; ++i) {
            context[i].updateFromFactHandle(workingMemory, handle);
        }
    }

    public void resetTuple(ContextEntry[] context) {
        for (int i = 0; i < context.length; ++i) {
            context[i].resetTuple();
        }
    }

    public void resetFactHandle(ContextEntry[] context) {
        for (int i = 0; i < context.length; ++i) {
            context[i].resetFactHandle();
        }
    }

    public boolean isAllowedCachedLeft(ContextEntry[] context, Object object) {
        LinkedListEntry entry = this.findNode(this.indexed + 1);
        int i = 1;
        while (entry != null) {
            if (!((BetaNodeFieldConstraint)entry.getObject()).isAllowedCachedLeft(context[this.indexed + i], object)) {
                return false;
            }
            entry = (LinkedListEntry)entry.getNext();
            ++i;
        }
        return true;
    }

    public boolean isAllowedCachedRight(ContextEntry[] context, ReteTuple tuple) {
        LinkedListEntry entry = this.findNode(this.indexed + 1);
        int i = 1;
        while (entry != null) {
            if (!((BetaNodeFieldConstraint)entry.getObject()).isAllowedCachedRight(tuple, context[this.indexed + i])) {
                return false;
            }
            entry = (LinkedListEntry)entry.getNext();
            ++i;
        }
        return true;
    }

    public boolean isIndexed() {
        return this.indexed >= 0;
    }

    public int getIndexCount() {
        return this.indexed + 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public BetaMemory createBetaMemory(RuleBaseConfiguration config) {
        BetaMemory memory;
        if (this.indexed >= 0) {
            LinkedListEntry entry = (LinkedListEntry)this.constraints.getFirst();
            ArrayList<AbstractHashTable.FieldIndex> list = new ArrayList<AbstractHashTable.FieldIndex>();
            for (int pos = 0; pos <= this.indexed; ++pos) {
                Constraint constraint = (Constraint)entry.getObject();
                VariableConstraint variableConstraint = (VariableConstraint)constraint;
                AbstractHashTable.FieldIndex index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
                list.add(index);
                entry = (LinkedListEntry)entry.getNext();
            }
            AbstractHashTable.FieldIndex[] indexes = list.toArray(new AbstractHashTable.FieldIndex[list.size()]);
            AbstractHashTable tupleMemory = config.isIndexLeftBetaMemory() ? new TupleIndexHashTable(indexes) : new TupleHashTable();
            FactHandleMemory factHandleMemory = config.isIndexRightBetaMemory() ? new FactHandleIndexHashTable(indexes) : (config.isSequential() ? new FactList() : new FactHashTable());
            memory = new BetaMemory((TupleMemory)((Object)(config.isSequential() ? null : tupleMemory)), factHandleMemory, this.createContext());
        } else {
            memory = new BetaMemory(config.isSequential() ? null : new TupleHashTable(), config.isSequential() ? new FactList() : new FactHashTable(), this.createContext());
        }
        return memory;
    }

    public int hashCode() {
        return this.constraints.hashCode();
    }

    public LinkedList getConstraints() {
        return this.constraints;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DefaultBetaConstraints)) {
            return false;
        }
        DefaultBetaConstraints other = (DefaultBetaConstraints)object;
        if (this.constraints == other.constraints) {
            return true;
        }
        if (this.constraints.size() != other.constraints.size()) {
            return false;
        }
        return this.constraints.equals(other);
    }
}

