/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.decisiontable.parser.Cell;
import org.drools.decisiontable.parser.Generator;
import org.drools.decisiontable.parser.Row;
import org.drools.decisiontable.parser.RuleTemplate;
import org.mvel.MVELTemplateRegistry;
import org.mvel.TemplateInterpreter;
import org.mvel.TemplateRegistry;

public class DefaultGenerator
implements Generator {
    private Map ruleTemplates;
    private TemplateRegistry registry = new MVELTemplateRegistry();
    private List rules = new ArrayList();

    public DefaultGenerator(Map t) {
        this.ruleTemplates = t;
    }

    public void generate(String templateName, Row row) {
        try {
            String content = this.getTemplate(templateName);
            HashMap<String, Row> vars = new HashMap<String, Row>();
            vars.put("row", row);
            Iterator it = row.getCells().iterator();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                cell.addValue(vars);
            }
            String drl = (String)TemplateInterpreter.parse(content, null, vars, this.registry);
            this.rules.add(drl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getTemplate(String templateName) throws IOException {
        String contents = this.registry.getTemplate(templateName);
        if (contents == null) {
            RuleTemplate template = (RuleTemplate)this.ruleTemplates.get(templateName);
            contents = template.getContents();
            this.registry.registerTemplate(templateName, contents);
        }
        return contents;
    }

    public String getDrl() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.rules.iterator();
        while (it.hasNext()) {
            String rule = (String)it.next();
            sb.append(rule).append("\n");
        }
        return sb.toString();
    }
}

