/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.decisiontable.parser.DecisionTableParseException;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.SheetListener;
import org.drools.decisiontable.parser.csv.CsvLineParser;

public class CsvParser
implements DecisionTableParser {
    private List _listeners;
    private CsvLineParser _lineParser;

    public CsvParser(SheetListener listener, CsvLineParser lineParser) {
        this._listeners = new ArrayList();
        this._listeners.add(listener);
        this._lineParser = lineParser;
    }

    public CsvParser(List listeners, CsvLineParser lineParser) {
        this._listeners = listeners;
        this._lineParser = lineParser;
    }

    public void parseFile(InputStream inStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        try {
            this.startSheet();
            this.processRows(reader);
            this.finishSheet();
        }
        catch (IOException e) {
            throw new DecisionTableParseException("An error occurred reading the CSV data.", e);
        }
    }

    private void startSheet() {
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            SheetListener listener = (SheetListener)it.next();
            listener.startSheet("csv");
        }
    }

    private void finishSheet() {
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            SheetListener listener = (SheetListener)it.next();
            listener.finishSheet();
        }
    }

    private void newRow(int row, int numCells) {
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            SheetListener listener = (SheetListener)it.next();
            listener.newRow(row, numCells);
        }
    }

    private void newCell(int row, int column, String value, int mergedColStart) {
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            SheetListener listener = (SheetListener)it.next();
            listener.newCell(row, column, value, mergedColStart);
        }
    }

    private void processRows(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        int row = 0;
        while (line != null) {
            List cells = this._lineParser.parse(line);
            this.newRow(row, cells.size());
            int startMergeCol = -1;
            for (int col = 0; col < cells.size(); ++col) {
                String cell = (String)cells.get(col);
                startMergeCol = this.calcStartMerge(startMergeCol, col, cell);
                cell = this.calcCellText(startMergeCol, cell);
                this.newCell(row, col, cell, startMergeCol);
            }
            ++row;
            line = reader.readLine();
        }
        this.finishSheet();
    }

    String calcCellText(int startMergeCol, String cell) {
        if (startMergeCol != -1) {
            cell = cell.substring(0, cell.length() - 3);
        }
        return cell;
    }

    int calcStartMerge(int startMergeCol, int col, String cell) {
        if (cell.endsWith("...") && startMergeCol == -1) {
            startMergeCol = col;
        } else if (!cell.endsWith("...")) {
            startMergeCol = -1;
        }
        return startMergeCol;
    }

    private void trimCells(List cells) {
        for (int i = cells.size() - 1; i > 0; --i) {
            String cell = (String)cells.get(i);
            if (!cell.trim().equals("")) {
                return;
            }
            cells.remove(i);
        }
    }
}

