/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.RuleFlowCompletedEvent;
import org.drools.event.RuleFlowEventListener;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.RuleFlowStartedEvent;
import org.drools.ruleflow.instance.RuleFlowProcessInstance;
import org.drools.spi.RuleFlowGroup;

public class RuleFlowEventSupport
implements Serializable {
    private static final long serialVersionUID = 400L;
    private final List listeners = Collections.synchronizedList(new ArrayList());

    public void addEventListener(RuleFlowEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(RuleFlowEventListener listener) {
        this.listeners.remove(listener);
    }

    public List getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireRuleFlowProcessStarted(RuleFlowProcessInstance instance, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowStartedEvent event = new RuleFlowStartedEvent(instance);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleFlowEventListener)this.listeners.get(i)).ruleFlowStarted(event, workingMemory);
        }
    }

    public void fireRuleFlowProcessCompleted(RuleFlowProcessInstance instance, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowCompletedEvent event = new RuleFlowCompletedEvent(instance);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleFlowEventListener)this.listeners.get(i)).ruleFlowCompleted(event, workingMemory);
        }
    }

    public void fireRuleFlowGroupActivated(RuleFlowGroup ruleFlowGroup, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowGroupActivatedEvent event = new RuleFlowGroupActivatedEvent(ruleFlowGroup);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleFlowEventListener)this.listeners.get(i)).ruleFlowGroupActivated(event, workingMemory);
        }
    }

    public void fireRuleFlowGroupDeactivated(RuleFlowGroup ruleFlowGroup, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowGroupDeactivatedEvent event = new RuleFlowGroupDeactivatedEvent(ruleFlowGroup);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((RuleFlowEventListener)this.listeners.get(i)).ruleFlowGroupDeactivated(event, workingMemory);
        }
    }

    public void reset() {
        this.listeners.clear();
    }
}

