/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSinkNode;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.EvalCondition;
import org.drools.spi.PropagationContext;
import org.drools.util.Iterator;
import org.drools.util.TupleHashTable;

public class EvalConditionNode
extends TupleSource
implements TupleSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private final EvalCondition condition;
    private final TupleSource tupleSource;
    protected boolean tupleMemoryEnabled;
    private TupleSinkNode previousTupleSinkNode;
    private TupleSinkNode nextTupleSinkNode;

    public EvalConditionNode(int id, TupleSource tupleSource, EvalCondition eval, BuildContext context) {
        super(id);
        this.condition = eval;
        this.tupleSource = tupleSource;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public EvalCondition getCondition() {
        return this.condition;
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this);
        boolean allowed = this.condition.isAllowed(tuple, workingMemory, memory.context);
        if (allowed) {
            if (this.tupleMemoryEnabled) {
                memory.tupleMemory.add(tuple);
            }
            this.sink.propagateAssertTuple(tuple, context, workingMemory);
        }
    }

    public void retractTuple(ReteTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this);
        ReteTuple memTuple = memory.tupleMemory.remove(tuple);
        if (memTuple != null) {
            this.sink.propagateRetractTuple(memTuple, context, workingMemory);
        }
    }

    public String toString() {
        return "[EvalConditionNode: cond=" + this.condition + "]";
    }

    public int hashCode() {
        return this.tupleSource.hashCode() ^ this.condition.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != EvalConditionNode.class) {
            return false;
        }
        EvalConditionNode other = (EvalConditionNode)object;
        return this.tupleSource.equals(other.tupleSource) && this.condition.equals(other.condition);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new EvalMemory(this.tupleMemoryEnabled, this.condition.createContext());
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.tupleMemory.iterator();
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            sink.assertTuple(tuple, context, workingMemory);
            tuple = (ReteTuple)it.next();
        }
    }

    public void remove(RuleRemovalContext context, BaseNode node, InternalWorkingMemory[] workingMemories) {
        context.visitTupleSource(this);
        if (!node.isInUse()) {
            this.removeTupleSink((TupleSink)((Object)node));
        }
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
        }
        if (!context.alreadyVisited(this.tupleSource)) {
            this.tupleSource.remove(context, this, workingMemories);
        }
    }

    public boolean isTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public TupleSinkNode getNextTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextTupleSinkNode(TupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public TupleSinkNode getPreviousTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousTupleSinkNode(TupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public static class EvalMemory
    implements Serializable {
        private static final long serialVersionUID = -2754669682742843929L;
        public TupleHashTable tupleMemory;
        public Object context;

        public EvalMemory(boolean tupleMemoryEnabled, Object context) {
            this.context = context;
            if (tupleMemoryEnabled) {
                this.tupleMemory = new TupleHashTable();
            }
        }
    }
}

