/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import org.drools.common.BaseNode;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.CompositeTupleSinkAdapter;
import org.drools.reteoo.EmptyTupleSinkAdapter;
import org.drools.reteoo.SingleTupleSinkAdapter;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSinkPropagator;
import org.drools.spi.PropagationContext;

public abstract class TupleSource
extends BaseNode
implements Serializable {
    protected TupleSinkPropagator sink = EmptyTupleSinkAdapter.getInstance();

    TupleSource(int id) {
        super(id);
    }

    protected void addTupleSink(TupleSink tupleSink) {
        if (this.sink instanceof EmptyTupleSinkAdapter) {
            this.sink = new SingleTupleSinkAdapter(tupleSink);
        } else if (this.sink instanceof SingleTupleSinkAdapter) {
            CompositeTupleSinkAdapter sinkAdapter = new CompositeTupleSinkAdapter();
            sinkAdapter.addTupleSink(this.sink.getSinks()[0]);
            sinkAdapter.addTupleSink(tupleSink);
            this.sink = sinkAdapter;
        } else {
            ((CompositeTupleSinkAdapter)this.sink).addTupleSink(tupleSink);
        }
    }

    protected void removeTupleSink(TupleSink tupleSink) {
        if (this.sink instanceof EmptyTupleSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleTupleSinkAdapter) {
            this.sink = EmptyTupleSinkAdapter.getInstance();
        } else {
            CompositeTupleSinkAdapter sinkAdapter = (CompositeTupleSinkAdapter)this.sink;
            sinkAdapter.removeTupleSink(tupleSink);
            if (sinkAdapter.size() == 1) {
                this.sink = new SingleTupleSinkAdapter(sinkAdapter.getSinks()[0]);
            }
        }
    }

    public TupleSinkPropagator getSinkPropagator() {
        return this.sink;
    }

    public abstract void updateSink(TupleSink var1, PropagationContext var2, InternalWorkingMemory var3);

    public boolean isInUse() {
        return this.sink.size() > 0;
    }
}

