/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.drools.RuntimeDroolsException;
import org.drools.base.ShadowProxy;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.Pattern;
import org.drools.spi.Extractor;

public class Declaration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 400L;
    private final String identifier;
    private final Extractor extractor;
    private Pattern pattern;
    private final boolean internalFact;

    public Declaration(String identifier, Extractor extractor, Pattern pattern) {
        this(identifier, extractor, pattern, false);
    }

    public Declaration(String identifier, Extractor extractor, Pattern pattern, boolean internalFact) {
        this.identifier = identifier;
        this.extractor = extractor;
        this.pattern = pattern;
        this.internalFact = internalFact;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ValueType getValueType() {
        return this.extractor.getValueType();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean isPatternDeclaration() {
        return this.pattern != null && this.pattern.getDeclaration() == this;
    }

    public Extractor getExtractor() {
        return this.extractor;
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getValue(workingMemory, object);
    }

    public Object getNonShadowedValue(InternalWorkingMemory workingMemory, Object object) {
        Object result = this.extractor.getValue(workingMemory, object);
        if (this.isInternalFact() && result instanceof Collection) {
            try {
                Collection newCol = (Collection)result.getClass().newInstance();
                Iterator it = ((Collection)result).iterator();
                while (it.hasNext()) {
                    Object element = it.next();
                    newCol.add(element instanceof ShadowProxy ? ((ShadowProxy)element).getShadowedObject() : element);
                }
                return newCol;
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return result;
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getCharValue(workingMemory, object);
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getIntValue(workingMemory, object);
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getByteValue(workingMemory, object);
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getShortValue(workingMemory, object);
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getLongValue(workingMemory, object);
    }

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getFloatValue(workingMemory, object);
    }

    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getDoubleValue(workingMemory, object);
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getBooleanValue(workingMemory, object);
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getHashCode(workingMemory, object);
    }

    public boolean isGlobal() {
        return this.extractor.isGlobal();
    }

    public Method getNativeReadMethod() {
        if (this.isPatternDeclaration() && this.isInternalFact()) {
            try {
                return this.getClass().getDeclaredMethod("getNonShadowedValue", InternalWorkingMemory.class, Object.class);
            }
            catch (Exception e) {
                throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
            }
        }
        return this.extractor.getNativeReadMethod();
    }

    public String toString() {
        return "[Declaration: type=" + this.extractor.getValueType() + " identifier=" + this.identifier + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * this.pattern.getOffset();
        result = 31 * this.extractor.hashCode();
        result = 31 * this.identifier.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Declaration other = (Declaration)object;
        return this.pattern.getOffset() == other.pattern.getOffset() && this.identifier.equals(other.identifier) && this.extractor.equals(other.extractor);
    }

    protected boolean isInternalFact() {
        return this.internalFact;
    }

    public Object clone() {
        return new Declaration(this.identifier, this.extractor, this.pattern);
    }
}

