/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.accumulators.JavaAccumulatorFunctionExecutor;
import org.drools.common.DroolsObjectInputStream;
import org.drools.rule.Accumulate;
import org.drools.rule.DroolsClassLoader;
import org.drools.rule.EvalCondition;
import org.drools.rule.LineMappings;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.Rule;
import org.drools.spi.Accumulator;
import org.drools.spi.Consequence;
import org.drools.spi.EvalExpression;
import org.drools.spi.PredicateExpression;
import org.drools.spi.ReturnValueExpression;

public class PackageCompilationData
implements Externalizable {
    private static final long serialVersionUID = 400L;
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return (class$org$drools$rule$PackageCompilationData == null ? (class$org$drools$rule$PackageCompilationData = PackageCompilationData.class$("org.drools.rule.PackageCompilationData")) : class$org$drools$rule$PackageCompilationData).getProtectionDomain();
        }
    });
    private Map invokerLookups;
    private Object AST;
    private Map store;
    private Map lineMappings;
    private transient PackageClassLoader classLoader;
    private transient ClassLoader parentClassLoader;
    private boolean dirty;
    static /* synthetic */ Class class$org$drools$rule$PackageCompilationData;

    public PackageCompilationData() {
    }

    public PackageCompilationData(ClassLoader parentClassLoader) {
        this.initClassLoader(parentClassLoader);
        this.invokerLookups = new HashMap();
        this.store = new HashMap();
        this.lineMappings = new HashMap();
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void initClassLoader(ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            throw new RuntimeDroolsException("PackageCompilationData cannot have a null parentClassLoader");
        }
        this.parentClassLoader = parentClassLoader;
        this.classLoader = new PackageClassLoader(this.parentClassLoader);
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.store);
        stream.writeObject(this.AST);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.invokerLookups);
        stream.writeObject(bos.toByteArray());
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        if (stream instanceof DroolsObjectInputStream) {
            DroolsObjectInputStream droolsStream = (DroolsObjectInputStream)stream;
            this.initClassLoader(droolsStream.getClassLoader());
        } else {
            this.initClassLoader(Thread.currentThread().getContextClassLoader());
        }
        this.store = (Map)stream.readObject();
        this.AST = stream.readObject();
        byte[] bytes = (byte[])stream.readObject();
        DroolsObjectInputStream streamWithLoader = new DroolsObjectInputStream(new ByteArrayInputStream(bytes), this.classLoader);
        this.invokerLookups = (Map)streamWithLoader.readObject();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public byte[] read(String resourceName) {
        byte[] bytes = null;
        if (this.store != null) {
            bytes = (byte[])this.store.get(resourceName);
        }
        return bytes;
    }

    public void write(String resourceName, byte[] clazzData) throws RuntimeDroolsException {
        if (this.store.put(resourceName, clazzData) != null) {
            this.dirty = true;
        } else {
            try {
                this.wire(PackageCompilationData.convertResourceToClassName(resourceName));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeDroolsException(e);
            }
        }
    }

    public boolean remove(String resourceName) throws RuntimeDroolsException {
        this.invokerLookups.remove(resourceName);
        if (this.store.remove(PackageCompilationData.convertClassToResourcePath(resourceName)) != null) {
            this.dirty = true;
            return true;
        }
        return false;
    }

    public String[] list() {
        if (this.store == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = this.store.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            names.add(name);
        }
        return names.toArray(new String[this.store.size()]);
    }

    public void reload() throws RuntimeDroolsException {
        this.classLoader = new PackageClassLoader(this.parentClassLoader);
        try {
            Iterator it = this.invokerLookups.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.wire((String)entry.getKey(), entry.getValue());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationError e) {
            throw new RuntimeDroolsException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException(e);
        }
        finally {
            this.dirty = false;
        }
    }

    public void clear() {
        this.store.clear();
        this.invokerLookups.clear();
        this.AST = null;
        this.reload();
    }

    public void wire(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object invoker = this.invokerLookups.get(className);
        this.wire(className, invoker);
    }

    public void wire(String className, Object invoker) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz = this.classLoader.findClass(className);
        if (invoker instanceof ReturnValueRestriction) {
            ((ReturnValueRestriction)invoker).setReturnValueExpression((ReturnValueExpression)clazz.newInstance());
        } else if (invoker instanceof PredicateConstraint) {
            ((PredicateConstraint)invoker).setPredicateExpression((PredicateExpression)clazz.newInstance());
        } else if (invoker instanceof EvalCondition) {
            ((EvalCondition)invoker).setEvalExpression((EvalExpression)clazz.newInstance());
        } else if (invoker instanceof Accumulate) {
            ((Accumulate)invoker).setAccumulator((Accumulator)clazz.newInstance());
        } else if (invoker instanceof Rule) {
            ((Rule)invoker).setConsequence((Consequence)clazz.newInstance());
        } else if (invoker instanceof JavaAccumulatorFunctionExecutor) {
            ((JavaAccumulatorFunctionExecutor)invoker).setExpression((ReturnValueExpression)clazz.newInstance());
        }
    }

    public String toString() {
        return this.getClass().getName() + this.store.toString();
    }

    public void putInvoker(String className, Object invoker) {
        this.invokerLookups.put(className, invoker);
    }

    public void putAllInvokers(Map invokers) {
        this.invokerLookups.putAll(invokers);
    }

    public Map getInvokers() {
        return this.invokerLookups;
    }

    public void removeInvoker(String className) {
        this.invokerLookups.remove(className);
    }

    public Map getLineMappings() {
        if (this.lineMappings == null) {
            this.lineMappings = new HashMap();
        }
        return this.lineMappings;
    }

    public LineMappings getLineMappings(String className) {
        return (LineMappings)this.getLineMappings().get(className);
    }

    public Object getAST() {
        return this.AST;
    }

    public void setAST(Object ast) {
        this.AST = ast;
    }

    public static String convertResourceToClassName(String pResourceName) {
        return PackageCompilationData.stripExtension(pResourceName).replace('/', '.');
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }

    public static String stripExtension(String pResourceName) {
        int i = pResourceName.lastIndexOf(46);
        String withoutExtension = pResourceName.substring(0, i);
        return withoutExtension;
    }

    public class PackageClassLoader
    extends ClassLoader
    implements DroolsClassLoader {
        public PackageClassLoader(ClassLoader parentClassLoader) {
            super(parentClassLoader);
        }

        public Class fastFindClass(String name) {
            byte[] clazzBytes;
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null && (clazzBytes = PackageCompilationData.this.read(PackageCompilationData.convertClassToResourcePath(name))) != null) {
                return this.defineClass(name, clazzBytes, 0, clazzBytes.length, PROTECTION_DOMAIN);
            }
            return clazz;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.fastFindClass(name);
            if (clazz == null) {
                ClassLoader parent = this.getParent();
                if (parent != null) {
                    clazz = parent.loadClass(name);
                } else {
                    throw new ClassNotFoundException(name);
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            Class clazz = this.fastFindClass(name);
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
            return clazz;
        }

        public InputStream getResourceAsStream(String name) {
            byte[] bytes = (byte[])PackageCompilationData.this.store.get(name);
            if (bytes != null) {
                return new ByteArrayInputStream(bytes);
            }
            InputStream input = this.getParent().getResourceAsStream(name);
            if (input == null) {
                input = super.getResourceAsStream(name);
            }
            return input;
        }
    }
}

