/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.drools.base.evaluators.DateFactory;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectRegistry;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.RuleError;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Package;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.DeclarationScopeResolver;

public class RuleBuildContext {
    private Package pkg;
    private PackageBuilderConfiguration configuration;
    private Rule rule;
    private Stack buildStack;
    private RuleDescr ruleDescr;
    private DeclarationScopeResolver declarationResolver;
    private int patternId = -1;
    private List errors;
    private List methods;
    private Map invokers;
    private Map invokerLookups;
    private Map descrLookups;
    private int counter;
    private DialectRegistry dialectRegistry;
    private Dialect dialect;

    public RuleBuildContext(PackageBuilderConfiguration configuration, Package pkg, RuleDescr ruleDescr, DialectRegistry dialectRegistry, Dialect defaultDialect) {
        this.configuration = configuration;
        this.pkg = pkg;
        this.methods = new ArrayList();
        this.invokers = new HashMap();
        this.invokerLookups = new HashMap();
        this.descrLookups = new HashMap();
        this.errors = new ArrayList();
        this.buildStack = new Stack();
        this.declarationResolver = new DeclarationScopeResolver(new Map[]{this.pkg.getGlobals()}, this.buildStack);
        this.ruleDescr = ruleDescr;
        this.rule = ruleDescr instanceof QueryDescr ? new Query(ruleDescr.getName()) : new Rule(ruleDescr.getName());
        this.rule.setPackage(pkg.getName());
        RuleBuildContext.setAttributes(this.rule, ruleDescr, ruleDescr.getAttributes());
        this.dialectRegistry = dialectRegistry;
        Dialect dialect = this.dialect = this.rule.getDialect() != null ? this.dialectRegistry.getDialect(this.rule.getDialect()) : defaultDialect;
        if (this.dialect == null && this.rule.getDialect() != null) {
            this.errors.add(new RuleError(this.rule, ruleDescr, null, "Unable to load Dialect '" + this.rule.getDialect() + "'"));
        }
        if (this.dialect != null) {
            this.dialect.init(ruleDescr);
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect(String dialectName) {
        return this.dialectRegistry.getDialect(dialectName);
    }

    public List getErrors() {
        return this.errors;
    }

    public Package getPkg() {
        return this.pkg;
    }

    public Rule getRule() {
        return this.rule;
    }

    public RuleDescr getRuleDescr() {
        return this.ruleDescr;
    }

    public DeclarationScopeResolver getDeclarationResolver() {
        return this.declarationResolver;
    }

    public void setDeclarationResolver(DeclarationScopeResolver variables) {
        this.declarationResolver = variables;
    }

    public Map getDescrLookups() {
        return this.descrLookups;
    }

    public void setDescrLookups(Map descrLookups) {
        this.descrLookups = descrLookups;
    }

    public Map getInvokerLookups() {
        return this.invokerLookups;
    }

    public void setInvokerLookups(Map invokerLookups) {
        this.invokerLookups = invokerLookups;
    }

    public Map getInvokers() {
        return this.invokers;
    }

    public void setInvokers(Map invokers) {
        this.invokers = invokers;
    }

    public List getMethods() {
        return this.methods;
    }

    public void setMethods(List methods) {
        this.methods = methods;
    }

    public int getCurrentId() {
        return this.counter;
    }

    public int getNextId() {
        return this.counter++;
    }

    public int getPatternId() {
        return this.patternId;
    }

    public int getNextPatternId() {
        return ++this.patternId;
    }

    public void setPatternId(int patternId) {
        this.patternId = patternId;
    }

    public Stack getBuildStack() {
        return this.buildStack;
    }

    public static void setAttributes(Rule rule, RuleDescr ruleDescr, List attributes) {
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            Calendar cal;
            AttributeDescr attributeDescr = (AttributeDescr)it.next();
            String name = attributeDescr.getName();
            if (name.equals("salience")) {
                try {
                    ruleDescr.setSalience(attributeDescr.getValue());
                }
                catch (Exception e) {}
                continue;
            }
            if (name.equals("no-loop")) {
                if (attributeDescr.getValue() == null) {
                    rule.setNoLoop(true);
                    continue;
                }
                rule.setNoLoop(Boolean.valueOf(attributeDescr.getValue()));
                continue;
            }
            if (name.equals("auto-focus")) {
                if (attributeDescr.getValue() == null) {
                    rule.setAutoFocus(true);
                    continue;
                }
                rule.setAutoFocus(Boolean.valueOf(attributeDescr.getValue()));
                continue;
            }
            if (name.equals("agenda-group")) {
                rule.setAgendaGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("activation-group")) {
                rule.setActivationGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("ruleflow-group")) {
                rule.setRuleFlowGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("lock-on-active")) {
                if (attributeDescr.getValue() == null) {
                    rule.setLockOnActive(true);
                    continue;
                }
                rule.setLockOnActive(Boolean.valueOf(attributeDescr.getValue()));
                continue;
            }
            if (name.equals("duration")) {
                rule.setDuration(Long.parseLong(attributeDescr.getValue()));
                rule.setAgendaGroup("");
                continue;
            }
            if (name.equals("enabled")) {
                if (attributeDescr.getValue() == null) {
                    rule.setEnabled(true);
                    continue;
                }
                rule.setEnabled(Boolean.valueOf(attributeDescr.getValue()));
                continue;
            }
            if (name.equals("date-effective")) {
                cal = Calendar.getInstance();
                cal.setTime(DateFactory.parseDate(attributeDescr.getValue()));
                rule.setDateEffective(cal);
                continue;
            }
            if (name.equals("date-expires")) {
                cal = Calendar.getInstance();
                cal.setTime(DateFactory.parseDate(attributeDescr.getValue()));
                rule.setDateExpires(cal);
                continue;
            }
            if (!name.equals("dialect")) continue;
            rule.setDialect(attributeDescr.getValue());
        }
    }

    public PackageBuilderConfiguration getConfiguration() {
        return this.configuration;
    }
}

