/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.ruleflow.core.Connection;
import org.drools.ruleflow.core.Node;

public abstract class NodeImpl
implements Node,
Serializable {
    protected static final NodeImpl[] EMPTY_NODE_ARRAY = new NodeImpl[0];
    private long id = -1L;
    private String name;
    private List incomingConnections = new ArrayList();
    private List outgoingConnections = new ArrayList();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getIncomingConnections() {
        return Collections.unmodifiableList(this.incomingConnections);
    }

    public List getOutgoingConnections() {
        return Collections.unmodifiableList(this.outgoingConnections);
    }

    protected void addIncomingConnection(Connection connection) {
        this.validateAddIncomingConnection(connection);
        this.incomingConnections.add(connection);
    }

    protected void validateAddIncomingConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        if (this.incomingConnections.contains(connection)) {
            throw new IllegalArgumentException("Connection is already added");
        }
    }

    protected void addOutgoingConnection(Connection connection) {
        this.validateAddOutgoingConnection(connection);
        this.outgoingConnections.add(connection);
    }

    protected void validateAddOutgoingConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        if (this.outgoingConnections.contains(connection)) {
            throw new IllegalArgumentException("Connection is already added");
        }
    }

    protected void removeIncomingConnection(Connection connection) {
        this.validateRemoveIncomingConnection(connection);
        this.incomingConnections.remove(connection);
    }

    protected void validateRemoveIncomingConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        if (!this.incomingConnections.contains(connection)) {
            throw new IllegalArgumentException("Given connection <" + connection + "> is not part of the incoming connections");
        }
    }

    protected void removeOutgoingConnection(Connection connection) {
        this.validateRemoveOutgoingConnection(connection);
        this.outgoingConnections.remove(connection);
    }

    protected void validateRemoveOutgoingConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        if (!this.outgoingConnections.contains(connection)) {
            throw new IllegalArgumentException("Given connection <" + connection + "> is not part of the outgoing connections");
        }
    }
}

