/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.drools.util.Iterator;
import org.drools.util.LinkedListNode;

public class LinkedList
implements Serializable {
    private static final long serialVersionUID = 400L;
    private LinkedListNode firstNode;
    private LinkedListNode lastNode;
    private int size;
    private LinkedListIterator iterator = new LinkedListIterator();

    public void add(LinkedListNode node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            this.lastNode.setNext(node);
            node.setPrevious(this.lastNode);
            this.lastNode = node;
        }
        ++this.size;
    }

    public void remove(LinkedListNode node) {
        if (this.firstNode == node) {
            this.removeFirst();
        } else if (this.lastNode == node) {
            this.removeLast();
        } else {
            node.getPrevious().setNext(node.getNext());
            node.getNext().setPrevious(node.getPrevious());
            --this.size;
            node.setPrevious(null);
            node.setNext(null);
        }
    }

    public final LinkedListNode getFirst() {
        return this.firstNode;
    }

    public final LinkedListNode getLast() {
        return this.lastNode;
    }

    public LinkedListNode removeFirst() {
        if (this.firstNode == null) {
            return null;
        }
        LinkedListNode node = this.firstNode;
        this.firstNode = node.getNext();
        node.setNext(null);
        if (this.firstNode != null) {
            this.firstNode.setPrevious(null);
        } else {
            this.lastNode = null;
        }
        --this.size;
        return node;
    }

    public void insertAfter(LinkedListNode existingNode, LinkedListNode newNode) {
        if (newNode.getPrevious() != null || newNode.getNext() != null) {
            return;
        }
        if (existingNode == null) {
            if (this.isEmpty()) {
                this.firstNode = newNode;
                this.lastNode = newNode;
            } else {
                LinkedListNode node = this.firstNode;
                node.setPrevious(newNode);
                newNode.setNext(node);
                this.firstNode = newNode;
            }
        } else if (existingNode == this.lastNode) {
            existingNode.setNext(newNode);
            newNode.setPrevious(existingNode);
            this.lastNode = newNode;
        } else {
            existingNode.getNext().setPrevious(newNode);
            newNode.setNext(existingNode.getNext());
            existingNode.setNext(newNode);
            newNode.setPrevious(existingNode);
        }
        ++this.size;
    }

    public LinkedListNode removeLast() {
        if (this.lastNode == null) {
            return null;
        }
        LinkedListNode node = this.lastNode;
        this.lastNode = node.getPrevious();
        node.setPrevious(null);
        if (this.lastNode != null) {
            this.lastNode.setNext(null);
        } else {
            this.firstNode = this.lastNode;
        }
        --this.size;
        return node;
    }

    public final boolean isEmpty() {
        return this.firstNode == null;
    }

    public void clear() {
        while (this.removeFirst() != null) {
        }
    }

    public final int size() {
        return this.size;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        for (LinkedListNode node = this.firstNode; node != null; node = node.getNext()) {
            result = 31 * result + node.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LinkedList)) {
            return false;
        }
        LinkedList other = (LinkedList)object;
        if (this.size() != other.size()) {
            return false;
        }
        LinkedListNode thisNode = this.firstNode;
        for (LinkedListNode otherNode = other.firstNode; thisNode != null && otherNode != null; thisNode = thisNode.getNext(), otherNode = otherNode.getNext()) {
            if (thisNode.equals(otherNode)) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        this.iterator.reset(this);
        return this.iterator;
    }

    public java.util.Iterator javaUtilIterator() {
        return new JavaUtilIterator(this);
    }

    public static class JavaUtilIterator
    implements java.util.Iterator,
    Serializable {
        private LinkedList list;
        private LinkedListNode currentNode;
        private LinkedListNode nextNode;
        private boolean immutable;

        public JavaUtilIterator(LinkedList list) {
            this(list, true);
        }

        public JavaUtilIterator(LinkedList list, boolean immutable) {
            this.list = list;
            this.nextNode = this.list.getFirst();
            this.immutable = immutable;
        }

        public boolean hasNext() {
            return this.nextNode != null;
        }

        public Object next() {
            this.currentNode = this.nextNode;
            if (this.currentNode == null) {
                throw new NoSuchElementException("No more elements to return");
            }
            this.nextNode = this.currentNode.getNext();
            return this.currentNode;
        }

        public void remove() {
            if (this.immutable) {
                throw new UnsupportedOperationException("This  Iterator is immutable, you cannot call remove()");
            }
            if (this.currentNode == null) {
                throw new IllegalStateException("No item to remove. Call next() before calling remove().");
            }
            this.list.remove(this.currentNode);
            this.currentNode = null;
        }
    }

    public class LinkedListIterator
    implements Iterator,
    Serializable {
        private LinkedList list;
        private LinkedListNode current;

        public void reset(LinkedList list) {
            this.list = list;
            this.current = this.list.firstNode;
        }

        public Object next() {
            if (this.current == null) {
                return null;
            }
            LinkedListNode node = this.current;
            this.current = this.current.getNext();
            return node;
        }
    }
}

