/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.InternalFactHandle;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleMemory;
import org.drools.util.AbstractHashTable;
import org.drools.util.Entry;
import org.drools.util.Iterator;

public class TupleIndexHashTable
extends AbstractHashTable
implements TupleMemory {
    private static final long serialVersionUID = 400L;
    public static final int PRIME = 31;
    private int startResult;
    private FieldIndexHashTableIterator tupleValueIterator;
    private FieldIndexHashTableFullIterator tupleValueFullIterator;
    private int factSize;
    private AbstractHashTable.Index index;

    public TupleIndexHashTable() {
    }

    public TupleIndexHashTable(AbstractHashTable.FieldIndex[] index) {
        this(16, 0.75f, index);
    }

    public TupleIndexHashTable(int capacity, float loadFactor, AbstractHashTable.FieldIndex[] index) {
        super(capacity, loadFactor);
        this.startResult = 31;
        int length = index.length;
        for (int i = 0; i < length; ++i) {
            this.startResult += 31 * this.startResult + index[i].getExtractor().getIndex();
        }
        switch (index.length) {
            case 0: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            }
            case 1: {
                this.index = new AbstractHashTable.SingleIndex(index, this.startResult);
                break;
            }
            case 2: {
                this.index = new AbstractHashTable.DoubleCompositeIndex(index, this.startResult);
                break;
            }
            case 3: {
                this.index = new AbstractHashTable.TripleCompositeIndex(index, this.startResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.startResult = in.readInt();
        this.factSize = in.readInt();
        this.tupleValueIterator = (FieldIndexHashTableIterator)in.readObject();
        this.tupleValueFullIterator = (FieldIndexHashTableFullIterator)in.readObject();
        this.index = (AbstractHashTable.Index)in.readObject();
        this.resize(this.table.length, true);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.startResult);
        out.writeInt(this.factSize);
        out.writeObject(this.tupleValueIterator);
        out.writeObject(this.tupleValueFullIterator);
        out.writeObject(this.index);
    }

    protected void updateHashCode(Entry entry) {
        ((FieldIndexEntry)entry).setHashCode(this.index.hashCodeOf(((FieldIndexEntry)entry).getFirst()));
    }

    public Iterator iterator() {
        if (this.tupleValueFullIterator == null) {
            this.tupleValueFullIterator = new FieldIndexHashTableFullIterator(this);
        }
        this.tupleValueFullIterator.reset();
        return this.tupleValueFullIterator;
    }

    public Iterator iterator(InternalFactHandle handle) {
        FieldIndexEntry entry;
        if (this.tupleValueIterator == null) {
            this.tupleValueIterator = new FieldIndexHashTableIterator();
        }
        this.tupleValueIterator.reset((entry = this.get(handle)) != null ? entry.first : null);
        return this.tupleValueIterator;
    }

    public boolean isIndexed() {
        return true;
    }

    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    public Entry getBucket(Object object) {
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        return this.table[index];
    }

    public Entry[] toArray() {
        Entry[] result = new Entry[this.factSize];
        int index = 0;
        for (int i = 0; i < this.table.length; ++i) {
            for (FieldIndexEntry fieldIndexEntry = (FieldIndexEntry)this.table[i]; fieldIndexEntry != null; fieldIndexEntry = (FieldIndexEntry)fieldIndexEntry.getNext()) {
                for (Entry entry = fieldIndexEntry.getFirst(); entry != null; entry = entry.getNext()) {
                    result[index++] = entry;
                }
            }
        }
        return result;
    }

    public void add(ReteTuple tuple) {
        FieldIndexEntry entry = this.getOrCreate(tuple);
        entry.add(tuple);
        ++this.factSize;
    }

    public boolean add(ReteTuple tuple, boolean checkExists) {
        throw new UnsupportedOperationException("FieldIndexHashTable does not support add(ReteTuple tuple, boolean checkExists)");
    }

    public ReteTuple remove(ReteTuple tuple) {
        FieldIndexEntry previous;
        int hashCode = this.index.hashCodeOf(tuple);
        int index = this.indexOf(hashCode, this.table.length);
        FieldIndexEntry current = previous = (FieldIndexEntry)this.table[index];
        while (current != null) {
            FieldIndexEntry next = (FieldIndexEntry)current.next;
            if (current.matches(tuple, hashCode)) {
                ReteTuple old = current.remove(tuple);
                --this.factSize;
                if (current.first == null) {
                    if (previous == current) {
                        this.table[index] = next;
                    } else {
                        previous.next = next;
                    }
                    current.next = null;
                    --this.size;
                }
                return old;
            }
            previous = current;
            current = next;
        }
        return null;
    }

    public boolean contains(ReteTuple tuple) {
        int hashCode = this.index.hashCodeOf(tuple);
        int index = this.indexOf(hashCode, this.table.length);
        FieldIndexEntry current = (FieldIndexEntry)this.table[index];
        while (current != null) {
            if (current.matches(tuple, hashCode)) {
                return true;
            }
            current = (FieldIndexEntry)current.next;
        }
        return false;
    }

    public FieldIndexEntry get(InternalFactHandle handle) {
        FieldIndexEntry entry;
        Object object = handle.getObject();
        int hashCode = this.index.hashCodeOf(handle.getObject());
        int index = this.indexOf(hashCode, this.table.length);
        for (entry = (FieldIndexEntry)this.table[index]; entry != null; entry = (FieldIndexEntry)entry.getNext()) {
            if (!entry.matches(object, hashCode)) continue;
            return entry;
        }
        return entry;
    }

    private FieldIndexEntry getOrCreate(ReteTuple tuple) {
        int hashCode = this.index.hashCodeOf(tuple);
        int index = this.indexOf(hashCode, this.table.length);
        FieldIndexEntry entry = (FieldIndexEntry)this.table[index];
        while (entry != null) {
            if (entry.matches(tuple, hashCode)) {
                return entry;
            }
            entry = (FieldIndexEntry)entry.next;
        }
        if (entry == null) {
            entry = new FieldIndexEntry(this.index, hashCode);
            entry.next = this.table[index];
            this.table[index] = entry;
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length, false);
            }
        }
        return entry;
    }

    public int size() {
        return this.factSize;
    }

    public static class FieldIndexEntry
    implements Entry {
        private static final long serialVersionUID = 400L;
        private Entry next;
        private ReteTuple first;
        private int hashCode;
        private AbstractHashTable.Index index;

        public FieldIndexEntry(AbstractHashTable.Index index, int hashCode) {
            this.index = index;
            this.hashCode = hashCode;
        }

        public void setHashCode(int hashCode) {
            this.hashCode = hashCode;
        }

        public Entry getNext() {
            return this.next;
        }

        public void setNext(Entry next) {
            this.next = next;
        }

        public ReteTuple getFirst() {
            return this.first;
        }

        public void add(ReteTuple tuple) {
            tuple.setNext(this.first);
            this.first = tuple;
        }

        public ReteTuple get(ReteTuple tuple) {
            for (ReteTuple current = this.first; current != null; current = (ReteTuple)current.getNext()) {
                if (!tuple.equals(current)) continue;
                return current;
            }
            return null;
        }

        public ReteTuple remove(ReteTuple tuple) {
            ReteTuple previous;
            ReteTuple current = previous = this.first;
            while (current != null) {
                ReteTuple next = (ReteTuple)current.getNext();
                if (tuple.equals(current)) {
                    if (this.first == current) {
                        this.first = next;
                    } else {
                        previous.setNext(next);
                    }
                    current.setNext(null);
                    return current;
                }
                previous = current;
                current = next;
            }
            return current;
        }

        public boolean matches(Object object, int objectHashCode) {
            return this.hashCode == objectHashCode && this.index.equal(object, this.first);
        }

        public boolean matches(ReteTuple tuple, int tupleHashCode) {
            return this.hashCode == tupleHashCode && this.index.equal(this.first, tuple);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            FieldIndexEntry other = (FieldIndexEntry)object;
            return this.hashCode == other.hashCode && this.index == other.index;
        }
    }

    public static class FieldIndexHashTableFullIterator
    implements Iterator {
        private AbstractHashTable hashTable;
        private Entry[] table;
        private int row;
        private int length;
        private Entry entry;

        public FieldIndexHashTableFullIterator(AbstractHashTable hashTable) {
            this.hashTable = hashTable;
        }

        public Object next() {
            if (this.entry == null) {
                while (this.entry == null) {
                    ++this.row;
                    if (this.row == this.length) {
                        return null;
                    }
                    this.entry = this.table[this.row] != null ? ((FieldIndexEntry)this.table[this.row]).first : null;
                }
            } else {
                this.entry = this.entry.getNext();
                if (this.entry == null) {
                    this.entry = (Entry)this.next();
                }
            }
            return this.entry;
        }

        public void reset() {
            this.table = this.hashTable.getTable();
            this.length = this.table.length;
            this.row = -1;
            this.entry = null;
        }
    }

    public static class FieldIndexHashTableIterator
    implements Iterator {
        private Entry entry;

        public Object next() {
            Entry current = this.entry;
            this.entry = this.entry != null ? this.entry.getNext() : null;
            return current;
        }

        public void reset(Entry entry) {
            this.entry = entry;
        }
    }
}

