/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.Configuration;
import org.drools.xml.Handler;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class FieldConstraintHandler
extends BaseAbstractHandler
implements Handler {
    FieldConstraintHandler(XmlPackageReader xmlPackageReader) {
        this.xmlPackageReader = xmlPackageReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(PatternDescr.class);
            this.validParents.add(AndDescr.class);
            this.validParents.add(OrDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(FieldConstraintDescr.class);
            this.validPeers.add(PredicateDescr.class);
            this.validPeers.add(FieldBindingDescr.class);
            this.validPeers.add(AndDescr.class);
            this.validPeers.add(OrDescr.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.xmlPackageReader.startConfiguration(localName, attrs);
        String fieldName = attrs.getValue("field-name");
        if (fieldName == null || fieldName.trim().equals("")) {
            throw new SAXParseException("<field-constraint> requires a 'field-name' attribute", this.xmlPackageReader.getLocator());
        }
        FieldConstraintDescr fieldConstraint = new FieldConstraintDescr(fieldName);
        return fieldConstraint;
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.xmlPackageReader.endConfiguration();
        FieldConstraintDescr fieldConstraintDescr = (FieldConstraintDescr)this.xmlPackageReader.getCurrent();
        LinkedList parents = this.xmlPackageReader.getParents();
        ListIterator it = parents.listIterator(parents.size());
        it.previous();
        Object parent = it.previous();
        if (parent instanceof PatternDescr) {
            PatternDescr patternDescr = (PatternDescr)parent;
            patternDescr.addConstraint(fieldConstraintDescr);
        } else if (parent instanceof ConditionalElementDescr) {
            ConditionalElementDescr ceDescr = (ConditionalElementDescr)parent;
            FieldConstraintDescr field = (FieldConstraintDescr)this.xmlPackageReader.getCurrent();
            ceDescr.addOrMerge(field);
        }
        return null;
    }

    public Class generateNodeFor() {
        return FieldConstraintDescr.class;
    }
}

