/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.integration.impl;

import java.util.Map;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.integration.VariableResolver;

public class MapVariableResolver
implements VariableResolver {
    private String name;
    private Class<?> knownType;
    private Map variableMap;
    private boolean cache = false;

    public MapVariableResolver(Map variableMap, String name) {
        this.variableMap = variableMap;
        this.name = name;
    }

    public MapVariableResolver(Map variableMap, String name, Class knownType) {
        this.name = name;
        this.knownType = knownType;
        this.variableMap = variableMap;
    }

    public MapVariableResolver(Map variableMap, String name, boolean cache) {
        this.variableMap = variableMap;
        this.name = name;
        this.cache = cache;
    }

    public MapVariableResolver(Map variableMap, String name, Class knownType, boolean cache) {
        this.name = name;
        this.knownType = knownType;
        this.variableMap = variableMap;
        this.cache = cache;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStaticType(Class knownType) {
        this.knownType = knownType;
    }

    public void setVariableMap(Map variableMap) {
        this.variableMap = variableMap;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.knownType;
    }

    public void setValue(Object value) {
        if (this.knownType != null && value != null && value.getClass() != this.knownType) {
            if (!DataConversion.canConvert(this.knownType, value.getClass())) {
                throw new CompileException("cannot assign " + value.getClass().getName() + " to type: " + this.knownType.getName());
            }
            try {
                value = DataConversion.convert(value, this.knownType);
            }
            catch (Exception e) {
                throw new CompileException("cannot convert value of " + value.getClass().getName() + " to: " + this.knownType.getName());
            }
        }
        this.variableMap.put(this.name, value);
    }

    public Object getValue() {
        return this.variableMap.get(this.name);
    }

    public int getFlags() {
        return 0;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }
}

