/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers;

import java.util.HashMap;
import java.util.Map;
import org.mvel.CompileException;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.impl.asm.ASMAccessorOptimizer;
import org.mvel.optimizers.impl.refl.ReflectiveAccessorOptimizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizerFactory {
    public static String SAFE_REFLECTIVE = "reflective";
    private static String defaultOptimizer = "ASM";
    private static final Map<String, AccessorOptimizer> accessorCompilers = new HashMap<String, AccessorOptimizer>();
    private static ThreadLocal<Class<? extends AccessorOptimizer>> threadOptimizer;

    static {
        accessorCompilers.put(SAFE_REFLECTIVE, new ReflectiveAccessorOptimizer());
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.mvel.asm.ClassWriter");
            accessorCompilers.put("ASM", new ASMAccessorOptimizer());
        }
        catch (ClassNotFoundException e) {
            defaultOptimizer = SAFE_REFLECTIVE;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("[MVEL] Notice: Possible incorrect version of ASM present (3.0 required).  Disabling JIT compiler.  Reflective Optimizer will be used.");
            defaultOptimizer = SAFE_REFLECTIVE;
        }
        if (Boolean.getBoolean("mvel.disable.jit")) {
            defaultOptimizer = SAFE_REFLECTIVE;
        }
    }

    public static AccessorOptimizer getDefaultAccessorCompiler() {
        try {
            return (AccessorOptimizer)accessorCompilers.get(defaultOptimizer).getClass().newInstance();
        }
        catch (Exception e) {
            throw new CompileException("unable to instantiate accessor compiler", e);
        }
    }

    public static AccessorOptimizer getAccessorCompiler(String name) {
        try {
            return (AccessorOptimizer)accessorCompilers.get(name).getClass().newInstance();
        }
        catch (Exception e) {
            throw new CompileException("unable to instantiate accessor compiler", e);
        }
    }

    public static AccessorOptimizer getThreadAccessorOptimizer() {
        if (threadOptimizer == null) {
            threadOptimizer = new ThreadLocal();
        }
        if (threadOptimizer.get() == null) {
            threadOptimizer.set(OptimizerFactory.getDefaultAccessorCompiler().getClass());
        }
        try {
            return threadOptimizer.get().newInstance();
        }
        catch (Exception e) {
            throw new CompileException("unable to instantiate accessor compiler", e);
        }
    }

    public static void setThreadAccessorOptimizer(Class<? extends AccessorOptimizer> optimizer) {
        if (threadOptimizer == null) {
            threadOptimizer = new ThreadLocal();
        }
        threadOptimizer.set(optimizer);
    }

    public static void setDefaultOptimizer(String name) {
        try {
            defaultOptimizer = name;
            OptimizerFactory.setThreadAccessorOptimizer(accessorCompilers.get(defaultOptimizer).getClass());
        }
        catch (Exception e) {
            throw new CompileException("unable to instantiate accessor compiler", e);
        }
    }
}

