/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.api.security.AuthenticationService;
import org.apache.servicemix.nmr.api.security.CertificateCallback;

public class JaasAuthenticationService
implements AuthenticationService {
    private static final Log LOG = LogFactory.getLog(JaasAuthenticationService.class);

    public void authenticate(Subject subject, String domain, final String user, final Object credentials) throws GeneralSecurityException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Authenticating '" + user + "' with '" + credentials + "'"));
        }
        LoginContext loginContext = new LoginContext(domain, subject, new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName(user);
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback && credentials instanceof String) {
                        ((PasswordCallback)callbacks[i]).setPassword(((String)credentials).toCharArray());
                        continue;
                    }
                    if (callbacks[i] instanceof CertificateCallback && credentials instanceof X509Certificate) {
                        ((CertificateCallback)callbacks[i]).setCertificate((X509Certificate)credentials);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
        });
        loginContext.login();
    }
}

