/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.io.IOException;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.cursors.AbstractStoreCursor;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class QueueStorePrefetch
extends AbstractStoreCursor {
    private static final Log LOG = LogFactory.getLog(QueueStorePrefetch.class);
    private MessageStore store;

    public QueueStorePrefetch(Queue queue) {
        super(queue);
        this.store = queue.getMessageStore();
    }

    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
        Message msg = this.store.getMessage(messageReference);
        if (msg != null) {
            return this.recoverMessage(msg);
        }
        String err = "Failed to retrieve message for id: " + messageReference;
        LOG.error((Object)err);
        throw new IOException(err);
    }

    protected synchronized int getStoreSize() {
        try {
            return this.store.getMessageCount();
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to get message count", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void resetBatch() {
        this.store.resetBatching();
    }

    protected void setBatch(MessageId messageId) {
        this.store.setBatch(messageId);
        this.batchResetNeeded = false;
    }

    protected void doFillBatch() throws Exception {
        this.store.recoverNextMessages(this.maxBatchSize, this);
    }

    public String toString() {
        return "QueueStorePrefetch" + System.identityHashCode(this);
    }
}

