/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.data.DataItem;
import org.apache.activemq.kaha.impl.data.Item;
import org.apache.activemq.kaha.impl.index.BadMagicException;

public class IndexItem
implements Item,
StoreEntry {
    public static final int INDEX_SIZE = 51;
    public static final int INDEXES_ONLY_SIZE = 19;
    protected long offset = -1L;
    IndexItem next;
    IndexItem prev;
    private long previousItem = -1L;
    private long nextItem = -1L;
    private boolean active = true;
    private long keyOffset = -1L;
    private int keyFile = -1;
    private int keySize;
    private long valueOffset = -1L;
    private int valueFile = -1;
    private int valueSize;

    void reset() {
        this.previousItem = -1L;
        this.nextItem = -1L;
        this.keyOffset = -1L;
        this.keyFile = -1;
        this.keySize = 0;
        this.valueOffset = -1L;
        this.valueFile = -1;
        this.valueSize = 0;
        this.active = true;
    }

    public StoreLocation getKeyDataItem() {
        DataItem result = new DataItem();
        result.setOffset(this.keyOffset);
        result.setFile(this.keyFile);
        result.setSize(this.keySize);
        return result;
    }

    public StoreLocation getValueDataItem() {
        DataItem result = new DataItem();
        result.setOffset(this.valueOffset);
        result.setFile(this.valueFile);
        result.setSize(this.valueSize);
        return result;
    }

    public void setValueData(StoreLocation item) {
        this.valueOffset = item.getOffset();
        this.valueFile = item.getFile();
        this.valueSize = item.getSize();
    }

    public void setKeyData(StoreLocation item) {
        this.keyOffset = item.getOffset();
        this.keyFile = item.getFile();
        this.keySize = item.getSize();
    }

    public void write(DataOutput dataOut) throws IOException {
        dataOut.writeShort(31317);
        dataOut.writeBoolean(this.active);
        dataOut.writeLong(this.previousItem);
        dataOut.writeLong(this.nextItem);
        dataOut.writeInt(this.keyFile);
        dataOut.writeLong(this.keyOffset);
        dataOut.writeInt(this.keySize);
        dataOut.writeInt(this.valueFile);
        dataOut.writeLong(this.valueOffset);
        dataOut.writeInt(this.valueSize);
    }

    void updateIndexes(DataOutput dataOut) throws IOException {
        dataOut.writeShort(31317);
        dataOut.writeBoolean(this.active);
        dataOut.writeLong(this.previousItem);
        dataOut.writeLong(this.nextItem);
    }

    public void read(DataInput dataIn) throws IOException {
        if (dataIn.readShort() != 31317) {
            throw new BadMagicException();
        }
        this.active = dataIn.readBoolean();
        this.previousItem = dataIn.readLong();
        this.nextItem = dataIn.readLong();
        this.keyFile = dataIn.readInt();
        this.keyOffset = dataIn.readLong();
        this.keySize = dataIn.readInt();
        this.valueFile = dataIn.readInt();
        this.valueOffset = dataIn.readLong();
        this.valueSize = dataIn.readInt();
    }

    void readIndexes(DataInput dataIn) throws IOException {
        if (dataIn.readShort() != 31317) {
            throw new BadMagicException();
        }
        this.active = dataIn.readBoolean();
        this.previousItem = dataIn.readLong();
        this.nextItem = dataIn.readLong();
    }

    public void setPreviousItem(long newPrevEntry) {
        this.previousItem = newPrevEntry;
    }

    long getPreviousItem() {
        return this.previousItem;
    }

    public void setNextItem(long newNextEntry) {
        this.nextItem = newNextEntry;
    }

    public long getNextItem() {
        return this.nextItem;
    }

    void setKeyOffset(long newObjectOffset) {
        this.keyOffset = newObjectOffset;
    }

    long getKeyOffset() {
        return this.keyOffset;
    }

    public int getKeyFile() {
        return this.keyFile;
    }

    void setKeyFile(int keyFile) {
        this.keyFile = keyFile;
    }

    public int getValueFile() {
        return this.valueFile;
    }

    void setValueFile(int valueFile) {
        this.valueFile = valueFile;
    }

    public long getValueOffset() {
        return this.valueOffset;
    }

    public void setValueOffset(long valueOffset) {
        this.valueOffset = valueOffset;
    }

    boolean isActive() {
        return this.active;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(int valueSize) {
        this.valueSize = valueSize;
    }

    void copyIndex(IndexItem other) {
        this.offset = other.offset;
        this.active = other.active;
        this.previousItem = other.previousItem;
        this.nextItem = other.nextItem;
    }

    public String toString() {
        String result = "offset=" + this.offset + ", key=(" + this.keyFile + ", " + this.keyOffset + ", " + this.keySize + ")" + ", value=(" + this.valueFile + ", " + this.valueOffset + ", " + this.valueSize + ")" + ", previousItem=" + this.previousItem + ", nextItem=" + this.nextItem;
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj != null && obj instanceof IndexItem) {
            IndexItem other = (IndexItem)obj;
            result = other.offset == this.offset;
        }
        return result;
    }

    public int hashCode() {
        return (int)this.offset;
    }
}

