/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v3;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v3.BaseDataStreamMarshaller;

public class MessageIdMarshaller
extends BaseDataStreamMarshaller {
    public byte getDataStructureType() {
        return 110;
    }

    public DataStructure createObject() {
        return new MessageId();
    }

    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        MessageId info = (MessageId)o;
        info.setProducerId((ProducerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setProducerSequenceId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info.setBrokerSequenceId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
    }

    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MessageId info = (MessageId)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getProducerId(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getProducerSequenceId(), bs);
        return (rc += this.tightMarshalLong1(wireFormat, info.getBrokerSequenceId(), bs)) + 0;
    }

    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        MessageId info = (MessageId)o;
        this.tightMarshalCachedObject2(wireFormat, info.getProducerId(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getProducerSequenceId(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getBrokerSequenceId(), dataOut, bs);
    }

    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        MessageId info = (MessageId)o;
        info.setProducerId((ProducerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setProducerSequenceId(this.looseUnmarshalLong(wireFormat, dataIn));
        info.setBrokerSequenceId(this.looseUnmarshalLong(wireFormat, dataIn));
    }

    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        MessageId info = (MessageId)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getProducerId(), dataOut);
        this.looseMarshalLong(wireFormat, info.getProducerSequenceId(), dataOut);
        this.looseMarshalLong(wireFormat, info.getBrokerSequenceId(), dataOut);
    }
}

