/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.activemq.thread.SchedulerTimerTask;

public final class Scheduler {
    private final Timer CLOCK_DAEMON = new Timer("ActiveMQ Scheduler", true);
    private final HashMap<Runnable, TimerTask> TIMER_TASKS = new HashMap();
    private static Scheduler instance = new Scheduler();

    private Scheduler() {
    }

    public static Scheduler getInstance() {
        return instance;
    }

    public synchronized void executePeriodically(Runnable task, long period) {
        SchedulerTimerTask timerTask = new SchedulerTimerTask(task);
        this.CLOCK_DAEMON.scheduleAtFixedRate((TimerTask)timerTask, period, period);
        this.TIMER_TASKS.put(task, timerTask);
    }

    public synchronized void cancel(Runnable task) {
        TimerTask ticket = this.TIMER_TASKS.remove(task);
        if (ticket != null) {
            ticket.cancel();
            this.CLOCK_DAEMON.purge();
        }
    }

    public void executeAfterDelay(Runnable task, long redeliveryDelay) {
        SchedulerTimerTask timerTask = new SchedulerTimerTask(task);
        this.CLOCK_DAEMON.schedule((TimerTask)timerTask, redeliveryDelay);
    }

    public void shutdown() {
        this.CLOCK_DAEMON.cancel();
    }
}

