/*
 * Decompiled with CFR 0.152.
 */
package org.joni.encoding.specific;

import org.joni.IntHolder;
import org.joni.encoding.specific.ASCIIEncoding;
import org.joni.encoding.unicode.UnicodeEncoding;

public final class UTF32LEEncoding
extends UnicodeEncoding {
    public static UTF32LEEncoding INSTANCE = new UTF32LEEncoding();

    protected UTF32LEEncoding() {
        super((int[])null);
    }

    public int length(byte c) {
        return 4;
    }

    public int strLength(byte[] bytes, int p, int end) {
        return end - p >>> 2;
    }

    public String toString() {
        return "UTF-32LE";
    }

    public int maxLength() {
        return 4;
    }

    public int minLength() {
        return 4;
    }

    public boolean isFixedWidth() {
        return true;
    }

    public boolean isNewLine(byte[] bytes, int p, int end) {
        return p + 3 < end && bytes[p] == 10 && bytes[p + 1] == 0 && bytes[p + 2] == 0 && bytes[p + 3] == 0;
    }

    public int mbcToCode(byte[] bytes, int p, int end) {
        return (((bytes[p + 3] & 0xFF) * 256 + (bytes[p + 2] & 0xFF)) * 256 + (bytes[p + 1] & 0xFF)) * 256 + (bytes[p] & 0xFF);
    }

    public int codeToMbcLength(int code) {
        return 4;
    }

    public int codeToMbc(int code, byte[] bytes, int p) {
        int p_ = p;
        bytes[p_++] = (byte)(code & 0xFF);
        bytes[p_++] = (byte)((code & 0xFF00) >>> 8);
        bytes[p_++] = (byte)((code & 0xFF0000) >>> 16);
        bytes[p_++] = (byte)((code & 0xFF000000) >>> 24);
        return 4;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end, byte[] fold) {
        int p = pp.value;
        int foldP = 0;
        if (UTF32LEEncoding.isAscii(bytes[p] & 0xFF) && bytes[p + 1] == 0 && bytes[p + 2] == 0 && bytes[p + 3] == 0) {
            fold[foldP++] = ASCIIEncoding.AsciiToLowerCaseTable[bytes[p] & 0xFF];
            fold[foldP++] = 0;
            fold[foldP++] = 0;
            fold[foldP] = 0;
            pp.value += 4;
            return 4;
        }
        return super.mbcCaseFold(flag, bytes, pp, end, fold);
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 0;
        return super.ctypeCodeRange(ctype);
    }

    public int leftAdjustCharHead(byte[] bytes, int p, int end) {
        if (end <= p) {
            return end;
        }
        return end - (end - p) % 4;
    }

    public boolean isReverseMatchAllowed(byte[] bytes, int p, int end) {
        return false;
    }
}

