/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import java.util.List;
import org.jruby.lexer.yacc.CapturingByteListLexerSource;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.parser.ParserConfiguration;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteListLexerSource
extends LexerSource {
    private int begin;
    private int realSize;
    private int index;
    private byte[] bytes;

    public ByteListLexerSource(String sourceName, ByteList bytelist, List<String> list, int line, boolean extraPositionInformation) {
        super(sourceName, list, line, extraPositionInformation);
        this.bytes = bytelist.bytes;
        this.begin = this.index = bytelist.begin();
        this.realSize = bytelist.realSize;
    }

    @Override
    public boolean matchMarker(ByteList marker, boolean indent, boolean checkNewline) throws IOException {
        int c;
        int start = this.index;
        if (indent) {
            while ((c = this.read()) != -1) {
                if (Character.isWhitespace(c) && c != 10) continue;
                --this.index;
                break;
            }
        }
        for (int i = 0; i < marker.length(); ++i) {
            if (marker.charAt(i) == this.read()) continue;
            this.index = start;
            return false;
        }
        if (!checkNewline) {
            return true;
        }
        c = (char)this.internalRead();
        if (c == -1 || c == 10) {
            return true;
        }
        this.index = start;
        return false;
    }

    @Override
    public boolean peek(int c) throws IOException {
        if (this.index >= this.realSize) {
            return c == -1;
        }
        return this.bytes[this.index] == c;
    }

    private byte internalRead() {
        return this.index >= this.realSize ? (byte)-1 : this.bytes[this.index++];
    }

    @Override
    public int read() throws IOException {
        int c = this.internalRead();
        switch (c) {
            case 13: {
                c = this.internalRead();
                if (c != 10) {
                    this.unread((char)c);
                    c = 10;
                    ++this.line;
                    break;
                }
                ++this.offset;
                break;
            }
            case 10: {
                ++this.line;
            }
        }
        return c;
    }

    @Override
    public ByteList readLineBytes() throws IOException {
        int count = 0;
        int c = this.read();
        while (c != 10 && c != -1) {
            ++count;
            c = this.read();
        }
        return new ByteList(this.bytes, this.index - count - 1, count, false);
    }

    @Override
    public int skipUntil(int c) throws IOException {
        c = this.read();
        while (c != 10 && c != -1) {
            c = this.read();
        }
        return c;
    }

    @Override
    public void unread(int c) {
        if (c == -1) {
            return;
        }
        --this.index;
        if (c == 10) {
            --this.line;
        }
    }

    @Override
    public void unreadMany(CharSequence line) {
        int length = line.length();
        this.index -= length;
    }

    @Override
    public boolean wasBeginOfLine() {
        return this.index == 0 || this.bytes[this.index - 1] == 10;
    }

    @Override
    public boolean lastWasBeginOfLine() {
        return this.index == 0 || this.bytes[this.index] == 10;
    }

    public static LexerSource getSource(String file, ByteList content, List<String> list, ParserConfiguration configuration) {
        if (list != null) {
            return new CapturingByteListLexerSource(file, content, list, configuration.getLineNumber(), configuration.hasExtraPositionInformation());
        }
        return new ByteListLexerSource(file, content, list, configuration.getLineNumber(), configuration.hasExtraPositionInformation());
    }

    @Override
    public int getOffset() {
        return this.index - this.begin + this.offset;
    }

    @Override
    public ByteList readUntil(char marker) throws IOException {
        int begin;
        int i;
        for (i = begin = this.index; i < this.realSize && this.bytes[i] != marker; ++i) {
        }
        if (i >= this.realSize) {
            return null;
        }
        this.index = i;
        return new ByteList(this.bytes, begin, i - begin, false);
    }

    public String toString() {
        try {
            ByteList buffer = new ByteList(20);
            buffer.append(this.bytes[this.index - 1]);
            buffer.append(this.bytes[this.index]);
            buffer.append(new byte[]{45, 62});
            for (int i = this.index + 1; i < this.index + 20 && this.index <= this.realSize; ++i) {
                buffer.append(this.bytes[i]);
            }
            buffer.append(new byte[]{32, 46, 46, 46});
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

