/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.filemonitor;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.kernel.filemonitor.DeploymentListener;
import org.apache.servicemix.kernel.filemonitor.FileMonitorActivator;
import org.apache.servicemix.kernel.filemonitor.JarUtil;
import org.apache.servicemix.kernel.filemonitor.Scanner;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMonitor {
    public static final String CONFIG_DIR = "org.apache.servicemix.filemonitor.configDir";
    public static final String DEPLOY_DIR = "org.apache.servicemix.filemonitor.monitorDir";
    public static final String GENERATED_JAR_DIR = "org.apache.servicemix.filemonitor.generatedJarDir";
    public static final String SCAN_INTERVAL = "org.apache.servicemix.filemonitor.scanInterval";
    protected static final String ALIAS_KEY = "_alias_factory_pid";
    private static final Log LOGGER = LogFactory.getLog(FileMonitor.class);
    private FileMonitorActivator activator;
    private File configDir;
    private File deployDir;
    private File generateDir;
    private Scanner scanner = new Scanner();
    private long scanInterval = 500L;
    private boolean loggedConfigAdminWarning;
    private List<Bundle> bundlesToStart = new ArrayList<Bundle>();
    private List<Bundle> bundlesToUpdate = new ArrayList<Bundle>();
    private Map<String, String> artifactToBundle = new HashMap<String, String>();
    private final Set<String> pendingTransformationArtifacts = new HashSet<String>();
    private final Set<Bundle> pendingStartBundles = new HashSet<Bundle>();
    private ServiceListener deployerListener;
    private BundleListener bundleListener;
    private Executor executor;

    public FileMonitor() {
        String base = System.getProperty("servicemix.base", ".");
        this.configDir = new File(base, "etc");
        this.deployDir = new File(base, "deploy");
        this.generateDir = new File(base, "data/generated-bundles");
    }

    public FileMonitor(FileMonitorActivator activator, Dictionary properties) {
        this();
        Long i;
        this.activator = activator;
        File value = this.getFileValue(properties, CONFIG_DIR);
        if (value != null) {
            this.configDir = value;
        }
        if ((value = this.getFileValue(properties, DEPLOY_DIR)) != null) {
            this.deployDir = value;
        }
        if ((value = this.getFileValue(properties, GENERATED_JAR_DIR)) != null) {
            this.generateDir = value;
        }
        if ((i = this.getLongValue(properties, SCAN_INTERVAL)) != null) {
            this.scanInterval = i;
        }
    }

    public void start() {
        this.executor = Executors.newSingleThreadExecutor();
        if (this.configDir != null) {
            this.configDir.mkdirs();
        }
        this.deployDir.mkdirs();
        this.generateDir.mkdirs();
        ArrayList<File> dirs = new ArrayList<File>();
        if (this.configDir != null) {
            dirs.add(this.configDir);
        }
        dirs.add(this.deployDir);
        this.scanner.setScanDirs(dirs);
        this.scanner.setScanInterval(this.scanInterval);
        this.scanner.addListener(new Scanner.BulkListener(){

            @Override
            public void filesChanged(List<String> filenames) throws Exception {
                FileMonitor.this.onFilesChanged(filenames);
            }
        });
        LOGGER.info((Object)("Starting to monitor the deploy directory: " + this.deployDir + " every " + this.scanInterval + " millis"));
        if (this.configDir != null) {
            LOGGER.info((Object)("Config directory is at: " + this.configDir));
        }
        LOGGER.info((Object)("Will generate bundles from expanded source directories to: " + this.generateDir));
        this.executor.execute(new Runnable(){

            public void run() {
                FileMonitor.this.scanner.start();
            }
        });
    }

    public void stop() {
        this.scanner.stop();
    }

    public BundleContext getContext() {
        return this.activator.getContext();
    }

    public FileMonitorActivator getActivator() {
        return this.activator;
    }

    public void setActivator(FileMonitorActivator activator) {
        this.activator = activator;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    public File getDeployDir() {
        return this.deployDir;
    }

    public void setDeployDir(File deployDir) {
        this.deployDir = deployDir;
    }

    public File getGenerateDir() {
        return this.generateDir;
    }

    public void setGenerateDir(File generateDir) {
        this.generateDir = generateDir;
    }

    public long getScanInterval() {
        return this.scanInterval;
    }

    public void setScanInterval(long scanInterval) {
        this.scanInterval = scanInterval;
    }

    protected synchronized void onFilesChanged(Collection<String> filenames) {
        this.bundlesToStart.clear();
        this.bundlesToUpdate.clear();
        HashSet<File> bundleJarsCreated = new HashSet<File>();
        for (String filename : filenames) {
            File file = new File(filename);
            try {
                File bundleDir;
                File parentFile;
                LOGGER.debug((Object)("File changed: " + filename));
                if (this.isValidConfigFile(file)) {
                    if (file.exists()) {
                        this.updateConfiguration(file);
                        continue;
                    }
                    this.deleteConfiguration(file);
                    continue;
                }
                if (!file.exists() && file.getName().equals("MANIFEST.MF") && (parentFile = file.getParentFile()).getName().equals("META-INF") && this.isValidBundleSourceDirectory(bundleDir = parentFile.getParentFile())) {
                    this.undeployBundle(bundleDir);
                    continue;
                }
                File jardir = this.getExpandedBundleRootDirectory(file);
                if (jardir != null) {
                    if (bundleJarsCreated.contains(jardir)) continue;
                    bundleJarsCreated.add(jardir);
                    file = this.createBundleJar(jardir);
                }
                if (file.exists()) {
                    File f = this.transformArtifact(file);
                    if (f == null) {
                        LOGGER.warn((Object)("Unsupported deployment: " + filename));
                        this.rescheduleTransformation(file);
                        continue;
                    }
                    file = f;
                } else {
                    String transformedFile = this.artifactToBundle.get(filename);
                    if (transformedFile != null && (file = new File(transformedFile)).exists()) {
                        file.delete();
                    }
                }
                if (!this.isValidArtifactFile(file)) continue;
                if (file.exists()) {
                    this.deployBundle(file);
                    continue;
                }
                this.undeployBundle(file);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Failed to process: " + file + ". Reason: " + e), (Throwable)e);
            }
        }
        this.refreshPackagesAndStartOrUpdateBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleTransformation(File file) {
        Set<String> set = this.pendingTransformationArtifacts;
        synchronized (set) {
            this.pendingTransformationArtifacts.add(file.getAbsolutePath());
        }
        if (this.deployerListener == null) {
            try {
                String filter = "(objectClass=" + DeploymentListener.class.getName() + ")";
                this.deployerListener = new ServiceListener(){

                    public void serviceChanged(ServiceEvent event) {
                        FileMonitor.this.executor.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                HashSet<String> files;
                                Set set = FileMonitor.this.pendingTransformationArtifacts;
                                synchronized (set) {
                                    files = new HashSet<String>(FileMonitor.this.pendingTransformationArtifacts);
                                    FileMonitor.this.pendingTransformationArtifacts.clear();
                                }
                                FileMonitor.this.onFilesChanged(files);
                            }
                        });
                    }
                };
                this.getContext().addServiceListener(this.deployerListener, filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File transformArtifact(File file) throws Exception {
        ServiceReference[] srvRefs = this.getContext().getAllServiceReferences(DeploymentListener.class.getName(), null);
        if (srvRefs != null) {
            for (ServiceReference sr : srvRefs) {
                try {
                    DeploymentListener deploymentListener = (DeploymentListener)this.getContext().getService(sr);
                    if (!deploymentListener.canHandle(file)) continue;
                    File transformedFile = deploymentListener.handle(file, this.getGenerateDir());
                    this.artifactToBundle.put(file.getAbsolutePath(), transformedFile.getAbsolutePath());
                    File file2 = transformedFile;
                    return file2;
                }
                finally {
                    this.getContext().ungetService(sr);
                }
            }
        }
        ZipFile jar = null;
        try {
            if (file.getName().endsWith("txt") || file.getName().endsWith("xml") || file.getName().endsWith("properties")) {
                File len$ = null;
                return len$;
            }
            jar = new JarFile(file);
            Manifest m = ((JarFile)jar).getManifest();
            if (m.getMainAttributes().getValue(new Attributes.Name("Bundle-SymbolicName")) != null && m.getMainAttributes().getValue(new Attributes.Name("Bundle-Version")) != null) {
                File file3 = file;
                return file3;
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Error transforming artifact " + file.getName()), (Throwable)e);
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployBundle(File file) throws IOException, BundleException {
        LOGGER.info((Object)("Deploying: " + file.getCanonicalPath()));
        FileInputStream in = new FileInputStream(file);
        try {
            Bundle bundle = this.getBundleForJarFile(file);
            if (bundle != null) {
                this.bundlesToUpdate.add(bundle);
            } else {
                bundle = this.getContext().installBundle(file.getCanonicalFile().toURI().toString(), (InputStream)in);
                if (!this.isBundleFragment(bundle)) {
                    this.bundlesToStart.add(bundle);
                }
            }
        }
        finally {
            this.closeQuietly(in);
        }
    }

    protected void undeployBundle(File file) throws BundleException, IOException {
        LOGGER.info((Object)("Undeploying: " + file.getCanonicalPath()));
        Bundle bundle = this.getBundleForJarFile(file);
        if (bundle == null) {
            LOGGER.warn((Object)("Could not find Bundle for file: " + file.getCanonicalPath()));
        } else {
            bundle.stop();
            bundle.uninstall();
        }
    }

    protected Bundle getBundleForJarFile(File file) throws IOException {
        Bundle[] bundles;
        String absoluteFilePath = file.getAbsoluteFile().toURI().toString();
        for (Bundle bundle : bundles = this.getContext().getBundles()) {
            String location = bundle.getLocation();
            if (!FileMonitor.filePathsMatch(absoluteFilePath, location)) continue;
            return bundle;
        }
        return null;
    }

    protected static boolean filePathsMatch(String p1, String p2) {
        p1 = FileMonitor.normalizeFilePath(p1);
        p2 = FileMonitor.normalizeFilePath(p2);
        return p1 != null && p1.equalsIgnoreCase(p2);
    }

    protected static String normalizeFilePath(String path) {
        if (path != null) {
            path = path.replaceFirst("file:/*", "");
            path = path.replaceAll("[\\\\/]+", "/");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConfiguration(File file) throws IOException, InvalidSyntaxException {
        ConfigurationAdmin configurationAdmin = this.activator.getConfigurationAdmin();
        if (configurationAdmin == null) {
            if (!this.loggedConfigAdminWarning) {
                LOGGER.warn((Object)"No ConfigurationAdmin so cannot deploy configurations");
                this.loggedConfigAdminWarning = true;
            }
        } else {
            Properties properties = new Properties();
            FileInputStream in = new FileInputStream(file);
            try {
                Configuration config;
                properties.load(in);
                this.interpolation(properties);
                this.closeQuietly(in);
                String[] pid = this.parsePid(file);
                Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
                hashtable.putAll(properties);
                if (pid[1] != null) {
                    hashtable.put(ALIAS_KEY, pid[1]);
                }
                if ((config = this.getConfiguration(pid[0], pid[1])).getBundleLocation() != null) {
                    config.setBundleLocation(null);
                }
                config.update(hashtable);
            }
            finally {
                this.closeQuietly(in);
            }
        }
    }

    protected void interpolation(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = properties.getProperty(key);
            Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(val);
            while (matcher.find()) {
                String rep = System.getProperty(matcher.group(1));
                if (rep == null) continue;
                val = val.replace(matcher.group(0), rep);
                matcher.reset(val);
            }
            properties.put(key, val);
        }
    }

    protected void deleteConfiguration(File file) throws IOException, InvalidSyntaxException {
        String[] pid = this.parsePid(file);
        Configuration config = this.getConfiguration(pid[0], pid[1]);
        config.delete();
    }

    protected Configuration getConfiguration(String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        ConfigurationAdmin configurationAdmin = this.activator.getConfigurationAdmin();
        if (factoryPid != null) {
            Configuration[] configs = configurationAdmin.listConfigurations("(|(_alias_factory_pid=" + pid + ")(.alias_factory_pid=" + factoryPid + "))");
            if (configs == null || configs.length == 0) {
                return configurationAdmin.createFactoryConfiguration(pid, null);
            }
            return configs[0];
        }
        return configurationAdmin.getConfiguration(pid, null);
    }

    protected String[] parsePid(File file) {
        String path = file.getName();
        String pid = path.substring(0, path.length() - 4);
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    protected PackageAdmin getPackageAdmin() {
        ServiceTracker packageAdminTracker = this.activator.getPackageAdminTracker();
        if (packageAdminTracker != null) {
            try {
                return (PackageAdmin)packageAdminTracker.waitForService(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean isBundleFragment(Bundle bundle) {
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin != null) {
            return packageAdmin.getBundleType(bundle) == 1;
        }
        return false;
    }

    protected void refreshPackagesAndStartOrUpdateBundles() {
        for (Bundle bundle : this.bundlesToUpdate) {
            try {
                bundle.update();
                LOGGER.info((Object)("Updated: " + bundle));
            }
            catch (BundleException e) {
                LOGGER.warn((Object)("Failed to update bundle: " + bundle + ". Reason: " + (Object)((Object)e)), (Throwable)e);
            }
        }
        for (Bundle bundle : this.bundlesToStart) {
            try {
                bundle.start();
                LOGGER.info((Object)("Started: " + bundle));
            }
            catch (BundleException e) {
                LOGGER.warn((Object)("Failed to start bundle: " + bundle + ". Reason: " + (Object)((Object)e)), (Throwable)e);
                this.rescheduleStart(bundle);
            }
        }
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin != null) {
            packageAdmin.refreshPackages(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleStart(Bundle bundle) {
        Set<Bundle> set = this.pendingStartBundles;
        synchronized (set) {
            this.pendingStartBundles.add(bundle);
            if (this.bundleListener == null) {
                this.bundleListener = new BundleListener(){

                    public void bundleChanged(BundleEvent event) {
                        if (event.getType() == 32) {
                            FileMonitor.this.executor.execute(new Runnable(){

                                public void run() {
                                    FileMonitor.this.retryPendingStartBundles();
                                }
                            });
                        }
                    }
                };
                this.getContext().addBundleListener(this.bundleListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retryPendingStartBundles() {
        Set<Bundle> set = this.pendingStartBundles;
        synchronized (set) {
            PackageAdmin packageAdmin;
            HashSet<Bundle> bundles = new HashSet<Bundle>();
            bundles.addAll(this.pendingStartBundles);
            this.pendingStartBundles.clear();
            boolean success = false;
            for (Bundle bundle : bundles) {
                try {
                    bundle.start();
                    LOGGER.info((Object)("Pending bundle started: " + bundle));
                    success = true;
                }
                catch (BundleException e) {
                    LOGGER.info((Object)("Pending bundle not started: " + bundle));
                    this.pendingStartBundles.add(bundle);
                }
            }
            if (success && (packageAdmin = this.getPackageAdmin()) != null) {
                packageAdmin.refreshPackages(null);
            }
        }
    }

    protected File createBundleJar(File dir) throws BundleException, IOException {
        File destFile = new File(this.generateDir, dir.getName() + ".jar");
        if (destFile.exists()) {
            this.undeployBundle(destFile);
            destFile.delete();
        }
        JarUtil.jarDir(dir.getPath(), destFile.getPath());
        return destFile;
    }

    protected File getExpandedBundleRootDirectory(File file) throws IOException {
        File parent = file.getParentFile();
        if (file.isDirectory()) {
            String rootPath = this.deployDir.getCanonicalPath();
            if (file.getCanonicalPath().equals(rootPath)) {
                return null;
            }
            if (this.containsManifest(file)) {
                return file;
            }
        }
        if (this.isValidBundleSourceDirectory(parent)) {
            return this.getExpandedBundleRootDirectory(parent);
        }
        return null;
    }

    protected boolean isValidBundleSourceDirectory(File dir) throws IOException {
        if (dir != null) {
            String rootPath;
            String parentPath = dir.getCanonicalPath();
            return !parentPath.equals(rootPath = this.deployDir.getCanonicalPath()) && parentPath.startsWith(rootPath);
        }
        return false;
    }

    protected boolean isValidArtifactFile(File file) throws IOException {
        if (file != null) {
            String filePath = file.getParentFile().getCanonicalPath();
            String deployPath = this.deployDir.getCanonicalPath();
            String generatePath = this.generateDir.getCanonicalPath();
            return filePath.equals(deployPath) || filePath.startsWith(generatePath);
        }
        return false;
    }

    protected boolean isValidConfigFile(File file) throws IOException {
        if (file != null && file.getName().endsWith(".cfg")) {
            String filePath = file.getParentFile().getCanonicalPath();
            String configPath = this.configDir.getCanonicalPath();
            return filePath.equals(configPath);
        }
        return false;
    }

    protected boolean containsManifest(File dir) {
        File metaInfDir = new File(dir, "META-INF");
        if (metaInfDir.exists() && metaInfDir.isDirectory()) {
            File manifest = new File(metaInfDir, "MANIFEST.MF");
            return manifest.exists() && !manifest.isDirectory();
        }
        return false;
    }

    protected File getFileValue(Dictionary properties, String key) {
        Object value = properties.get(key);
        if (value instanceof File) {
            return (File)value;
        }
        if (value != null) {
            return new File(value.toString());
        }
        return null;
    }

    protected Long getLongValue(Dictionary properties, String key) {
        Object value = properties.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value != null) {
            return Long.parseLong(value.toString());
        }
        return null;
    }

    protected void closeQuietly(Closeable in) {
        try {
            in.close();
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Failed to close stream. " + e), (Throwable)e);
        }
    }
}

